/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.review;

import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class ReviewDto {
    public static final String STATUS_OPEN = "OPEN";
    public static final String STATUS_REOPENED = "REOPENED";
    public static final String STATUS_RESOLVED = "RESOLVED";
    public static final String STATUS_CLOSED = "CLOSED";
    public static final String RESOLUTION_FALSE_POSITIVE = "FALSE-POSITIVE";
    public static final String RESOLUTION_FIXED = "FIXED";
    private Long id;
    private Integer userId;
    private Long assigneeId;
    private String title;
    private String status;
    private String resolution;
    private Integer violationPermanentId;
    private Integer projectId;
    private Integer resourceId;
    private Integer line;
    private Date createdAt;
    private Date updatedAt;
    private String severity;
    private Integer ruleId;
    private boolean manualViolation;
    private boolean manualSeverity;
    private Integer actionPlanId;
    private String data;

    public Long getId() {
        return this.id;
    }

    public ReviewDto setId(Long id) {
        this.id = id;
        return this;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public ReviewDto setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    public Long getAssigneeId() {
        return this.assigneeId;
    }

    public ReviewDto setAssigneeId(@Nullable Long assigneeId) {
        this.assigneeId = assigneeId;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public ReviewDto setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public ReviewDto setStatus(@Nullable String status) {
        this.status = status;
        return this;
    }

    public String getResolution() {
        return this.resolution;
    }

    public ReviewDto setResolution(@Nullable String resolution) {
        this.resolution = resolution;
        return this;
    }

    public Integer getViolationPermanentId() {
        return this.violationPermanentId;
    }

    public ReviewDto setViolationPermanentId(Integer violationPermanentId) {
        this.violationPermanentId = violationPermanentId;
        return this;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public ReviewDto setProjectId(Integer projectId) {
        this.projectId = projectId;
        return this;
    }

    public Integer getResourceId() {
        return this.resourceId;
    }

    public ReviewDto setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public Integer getLine() {
        return this.line;
    }

    public ReviewDto setLine(@Nullable Integer line) {
        this.line = line;
        return this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public ReviewDto setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public ReviewDto setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public String getSeverity() {
        return this.severity;
    }

    public ReviewDto setSeverity(@Nullable String severity) {
        this.severity = severity;
        return this;
    }

    public Integer getRuleId() {
        return this.ruleId;
    }

    public ReviewDto setRuleId(Integer ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    public boolean getManualViolation() {
        return this.manualViolation;
    }

    public boolean isManualViolation() {
        return this.manualViolation;
    }

    public ReviewDto setManualViolation(boolean b) {
        this.manualViolation = b;
        return this;
    }

    public boolean getManualSeverity() {
        return this.manualSeverity;
    }

    public ReviewDto setManualSeverity(boolean b) {
        this.manualSeverity = b;
        return this;
    }

    public boolean isManualSeverity() {
        return this.manualSeverity;
    }

    public Integer getActionPlanId() {
        return this.actionPlanId;
    }

    public ReviewDto setActionPlanId(@Nullable Integer i) {
        this.actionPlanId = i;
        return this;
    }

    public String getData() {
        return this.data;
    }

    public ReviewDto setData(String s) {
        Preconditions.checkArgument((s == null || s.length() <= 4000 ? 1 : 0) != 0, (Object)("Review data must not exceed 4000 characters: " + s));
        this.data = s;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReviewDto reviewDto = (ReviewDto)o;
        return !(this.id == null ? reviewDto.id != null : !this.id.equals(reviewDto.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

