/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.review;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.core.persistence.BatchSession;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.review.ReviewDto;
import org.sonar.core.review.ReviewMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewDao
implements BatchComponent,
ServerComponent {
    private final MyBatis mybatis;
    private final Cache<Long, Collection<ReviewDto>> cacheByResource;

    public ReviewDao(MyBatis mybatis) {
        this.mybatis = mybatis;
        this.cacheByResource = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<Long, Collection<ReviewDto>>(){

            public Collection<ReviewDto> load(Long resourceId) {
                return ReviewDao.this.doSelectOpenByResourceId(resourceId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReviewDto findById(long reviewId) {
        SqlSession session = this.mybatis.openSession();
        try {
            ReviewMapper mapper = (ReviewMapper)session.getMapper(ReviewMapper.class);
            ReviewDto reviewDto = mapper.findById(reviewId);
            return reviewDto;
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }

    public Collection<ReviewDto> selectOpenByResourceId(long resourceId, Predicate<ReviewDto> ... predicates) {
        Collection reviews = (Collection)this.cacheByResource.getUnchecked((Object)resourceId);
        if (!reviews.isEmpty() && predicates != null) {
            reviews = Collections2.filter((Collection)reviews, (Predicate)Predicates.and(predicates));
        }
        return reviews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ReviewDto> selectOnDeletedResources(long rootProjectId, long rootSnapshotId) {
        SqlSession session = this.mybatis.openSession();
        try {
            ReviewMapper mapper = (ReviewMapper)session.getMapper(ReviewMapper.class);
            List<ReviewDto> list = mapper.selectOnDeletedResources(rootProjectId, rootSnapshotId);
            return list;
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ReviewDto> doSelectOpenByResourceId(long resourceId) {
        SqlSession session = this.mybatis.openSession();
        try {
            ReviewMapper mapper = (ReviewMapper)session.getMapper(ReviewMapper.class);
            List<ReviewDto> list = mapper.selectByResourceId(resourceId);
            return list;
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReviewDao update(Collection<ReviewDto> reviews) {
        Preconditions.checkNotNull(reviews);
        BatchSession session = this.mybatis.openBatchSession();
        try {
            ReviewMapper mapper = (ReviewMapper)session.getMapper(ReviewMapper.class);
            for (ReviewDto review : reviews) {
                mapper.update(review);
            }
            session.commit();
            ReviewDao reviewDao = this;
            return reviewDao;
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }
}

