/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.resource;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.resource.ResourceDto;
import org.sonar.core.resource.ResourceMapper;
import org.sonar.core.resource.ResourceQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDao {
    private MyBatis mybatis;

    public ResourceDao(MyBatis mybatis) {
        this.mybatis = mybatis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceDto> getResources(ResourceQuery query) {
        SqlSession session = this.mybatis.openSession();
        try {
            List<ResourceDto> list = ((ResourceMapper)session.getMapper(ResourceMapper.class)).selectResources(query);
            return list;
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getResourceIds(ResourceQuery query) {
        SqlSession session = this.mybatis.openSession();
        try {
            List<Long> list = ((ResourceMapper)session.getMapper(ResourceMapper.class)).selectResourceIds(query);
            return list;
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceDto getResource(long projectId) {
        SqlSession session = this.mybatis.openSession();
        try {
            ResourceDto resourceDto = this.getResource(projectId, session);
            return resourceDto;
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }

    public ResourceDto getResource(long projectId, SqlSession session) {
        return ((ResourceMapper)session.getMapper(ResourceMapper.class)).selectResource(projectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceDto> getDescendantProjects(long projectId) {
        SqlSession session = this.mybatis.openSession();
        try {
            List<ResourceDto> list = this.getDescendantProjects(projectId, session);
            return list;
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }

    public List<ResourceDto> getDescendantProjects(long projectId, SqlSession session) {
        ResourceMapper mapper = (ResourceMapper)session.getMapper(ResourceMapper.class);
        ArrayList resources = Lists.newArrayList();
        this.appendChildProjects(projectId, mapper, resources);
        return resources;
    }

    private void appendChildProjects(long projectId, ResourceMapper mapper, List<ResourceDto> resources) {
        List<ResourceDto> subProjects = mapper.selectDescendantProjects(projectId);
        for (ResourceDto subProject : subProjects) {
            resources.add(subProject);
            this.appendChildProjects(subProject.getId(), mapper, resources);
        }
    }
}

