/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.purge;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.core.persistence.BatchSession;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.purge.PurgeCommands;
import org.sonar.core.purge.PurgeMapper;
import org.sonar.core.purge.PurgeSnapshotQuery;
import org.sonar.core.purge.PurgeVendorMapper;
import org.sonar.core.purge.PurgeableSnapshotDto;
import org.sonar.core.resource.ResourceDao;
import org.sonar.core.resource.ResourceDto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgeDao {
    private final MyBatis mybatis;
    private final ResourceDao resourceDao;
    private static final Logger LOG = LoggerFactory.getLogger(PurgeDao.class);

    public PurgeDao(MyBatis mybatis, ResourceDao resourceDao) {
        this.mybatis = mybatis;
        this.resourceDao = resourceDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PurgeDao purge(long rootResourceId, String[] scopesWithoutHistoricalData) {
        BatchSession session = this.mybatis.openBatchSession();
        PurgeMapper purgeMapper = (PurgeMapper)session.getMapper(PurgeMapper.class);
        PurgeCommands commands = new PurgeCommands(session, purgeMapper, (PurgeVendorMapper)session.getMapper(PurgeVendorMapper.class));
        try {
            List<ResourceDto> projects = this.getProjects(rootResourceId, session);
            for (ResourceDto project : projects) {
                LOG.info("-> Clean " + project.getLongName() + " [id=" + project.getId() + "]");
                this.deleteAbortedBuilds(project, commands);
                this.purge(project, scopesWithoutHistoricalData, commands);
            }
            for (ResourceDto project : projects) {
                this.disableOrphanResources(project, session, purgeMapper);
            }
        }
        finally {
            MyBatis.closeQuietly(session);
        }
        return this;
    }

    private void deleteAbortedBuilds(ResourceDto project, PurgeCommands commands) {
        if (this.hasAbortedBuilds(project.getId(), commands)) {
            LOG.info("<- Delete aborted builds");
            PurgeSnapshotQuery query = PurgeSnapshotQuery.create().setIslast(false).setStatus(new String[]{"U"}).setRootProjectId(project.getId());
            commands.deleteSnapshots(query);
        }
    }

    private boolean hasAbortedBuilds(Long projectId, PurgeCommands commands) {
        PurgeSnapshotQuery query = PurgeSnapshotQuery.create().setIslast(false).setStatus(new String[]{"U"}).setResourceId(projectId);
        return !commands.selectSnapshotIds(query).isEmpty();
    }

    private void purge(ResourceDto project, String[] scopesWithoutHistoricalData, PurgeCommands purgeCommands) {
        List<Long> projectSnapshotIds = purgeCommands.selectSnapshotIds(PurgeSnapshotQuery.create().setResourceId(project.getId()).setIslast(false).setNotPurged(true));
        for (Long projectSnapshotId : projectSnapshotIds) {
            PurgeSnapshotQuery query;
            LOG.info("<- Clean snapshot " + projectSnapshotId);
            if (!ArrayUtils.isEmpty((Object[])scopesWithoutHistoricalData)) {
                query = PurgeSnapshotQuery.create().setIslast(false).setScopes(scopesWithoutHistoricalData).setRootSnapshotId(projectSnapshotId);
                purgeCommands.deleteSnapshots(query);
            }
            query = PurgeSnapshotQuery.create().setRootSnapshotId(projectSnapshotId).setNotPurged(true);
            purgeCommands.purgeSnapshots(query);
            purgeCommands.purgeSnapshots(PurgeSnapshotQuery.create().setId(projectSnapshotId).setNotPurged(true));
        }
    }

    private void disableOrphanResources(ResourceDto project, SqlSession session, final PurgeMapper purgeMapper) {
        session.select("org.sonar.core.purge.PurgeMapper.selectResourceIdsToDisable", (Object)project.getId(), new ResultHandler(){

            public void handleResult(ResultContext resultContext) {
                Long resourceId = (Long)resultContext.getResultObject();
                if (resourceId != null) {
                    PurgeDao.this.disableResource(resourceId, purgeMapper);
                }
            }
        });
        session.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PurgeableSnapshotDto> selectPurgeableSnapshots(long resourceId) {
        BatchSession session = this.mybatis.openBatchSession();
        try {
            PurgeMapper mapper = (PurgeMapper)session.getMapper(PurgeMapper.class);
            ArrayList result = Lists.newArrayList();
            result.addAll(mapper.selectPurgeableSnapshotsWithEvents(resourceId));
            result.addAll(mapper.selectPurgeableSnapshotsWithoutEvents(resourceId));
            Collections.sort(result);
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PurgeDao deleteResourceTree(long rootProjectId) {
        BatchSession session = this.mybatis.openBatchSession();
        PurgeMapper mapper = (PurgeMapper)session.getMapper(PurgeMapper.class);
        try {
            this.deleteProject(rootProjectId, mapper, new PurgeCommands(session));
            PurgeDao purgeDao = this;
            return purgeDao;
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }

    private void deleteProject(long rootProjectId, PurgeMapper mapper, PurgeCommands commands) {
        List<Long> childrenIds = mapper.selectProjectIdsByRootId(rootProjectId);
        for (Long childId : childrenIds) {
            this.deleteProject(childId, mapper, commands);
        }
        List<Long> resourceIds = mapper.selectResourceIdsByRootId(rootProjectId);
        commands.deleteResources(resourceIds);
    }

    @VisibleForTesting
    void disableResource(long resourceId, PurgeMapper mapper) {
        mapper.deleteResourceIndex(resourceId);
        mapper.setSnapshotIsLastToFalse(resourceId);
        mapper.disableResource(resourceId);
        mapper.closeResourceReviews(resourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PurgeDao deleteSnapshots(PurgeSnapshotQuery query) {
        BatchSession session = this.mybatis.openBatchSession();
        try {
            new PurgeCommands(session).deleteSnapshots(query);
            PurgeDao purgeDao = this;
            return purgeDao;
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }

    private List<ResourceDto> getProjects(long rootProjectId, SqlSession session) {
        ArrayList projects = Lists.newArrayList();
        projects.add(this.resourceDao.getResource(rootProjectId, session));
        projects.addAll(this.resourceDao.getDescendantProjects(rootProjectId, session));
        return projects;
    }
}

