/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.purge;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.sonar.core.purge.PurgeMapper;
import org.sonar.core.purge.PurgeSnapshotQuery;
import org.sonar.core.purge.PurgeVendorMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PurgeCommands {
    private final SqlSession session;
    private final PurgeMapper purgeMapper;
    private final PurgeVendorMapper purgeVendorMapper;

    PurgeCommands(SqlSession session, PurgeMapper purgeMapper, PurgeVendorMapper purgeVendorMapper) {
        this.session = session;
        this.purgeMapper = purgeMapper;
        this.purgeVendorMapper = purgeVendorMapper;
    }

    @VisibleForTesting
    PurgeCommands(SqlSession session) {
        this(session, (PurgeMapper)session.getMapper(PurgeMapper.class), (PurgeVendorMapper)session.getMapper(PurgeVendorMapper.class));
    }

    List<Long> selectSnapshotIds(PurgeSnapshotQuery query) {
        return this.purgeMapper.selectSnapshotIds(query);
    }

    void deleteResources(List<Long> resourceIds) {
        for (Long resourceId : resourceIds) {
            this.deleteSnapshots(PurgeSnapshotQuery.create().setResourceId(resourceId));
        }
        for (Long resourceId : resourceIds) {
            this.purgeMapper.deleteResourceLinks(resourceId);
        }
        this.session.commit();
        for (Long resourceId : resourceIds) {
            this.purgeMapper.deleteResourceProperties(resourceId);
        }
        this.session.commit();
        for (Long resourceId : resourceIds) {
            this.purgeMapper.deleteResourceIndex(resourceId);
        }
        this.session.commit();
        for (Long resourceId : resourceIds) {
            this.purgeMapper.deleteResourceGroupRoles(resourceId);
        }
        this.session.commit();
        for (Long resourceId : resourceIds) {
            this.purgeMapper.deleteResourceUserRoles(resourceId);
        }
        this.session.commit();
        for (Long resourceId : resourceIds) {
            this.purgeMapper.deleteResourceManualMeasures(resourceId);
        }
        this.session.commit();
        for (Long resourceId : resourceIds) {
            this.purgeVendorMapper.deleteResourceReviewComments(resourceId);
        }
        this.session.commit();
        for (Long resourceId : resourceIds) {
            this.purgeVendorMapper.deleteResourceActionPlansReviews(resourceId);
        }
        this.session.commit();
        for (Long resourceId : resourceIds) {
            this.purgeMapper.deleteResourceReviews(resourceId);
        }
        this.session.commit();
        for (Long resourceId : resourceIds) {
            this.purgeMapper.deleteResourceActionPlans(resourceId);
        }
        this.session.commit();
        for (Long resourceId : resourceIds) {
            this.purgeMapper.deleteResourceEvents(resourceId);
        }
        this.session.commit();
        for (Long resourceId : resourceIds) {
            this.purgeMapper.deleteResource(resourceId);
        }
        this.session.commit();
        for (Long resourceId : resourceIds) {
            this.purgeMapper.deleteAuthors(resourceId);
        }
        this.session.commit();
    }

    void deleteSnapshots(PurgeSnapshotQuery query) {
        this.deleteSnapshots(this.purgeMapper.selectSnapshotIds(query));
    }

    private void deleteSnapshots(List<Long> snapshotIds) {
        for (Long snapshotId : snapshotIds) {
            this.purgeMapper.deleteSnapshotDependencies(snapshotId);
        }
        this.session.commit();
        for (Long snapshotId : snapshotIds) {
            this.purgeMapper.deleteSnapshotDuplications(snapshotId);
        }
        this.session.commit();
        for (Long snapshotId : snapshotIds) {
            this.purgeMapper.deleteSnapshotEvents(snapshotId);
        }
        this.session.commit();
        for (Long snapshotId : snapshotIds) {
            this.purgeMapper.deleteSnapshotMeasureData(snapshotId);
        }
        this.session.commit();
        for (Long snapshotId : snapshotIds) {
            this.purgeMapper.deleteSnapshotMeasures(snapshotId);
        }
        this.session.commit();
        for (Long snapshotId : snapshotIds) {
            this.purgeMapper.deleteSnapshotSource(snapshotId);
        }
        this.session.commit();
        for (Long snapshotId : snapshotIds) {
            this.purgeMapper.deleteSnapshotViolations(snapshotId);
        }
        this.session.commit();
        for (Long snapshotId : snapshotIds) {
            this.purgeMapper.deleteSnapshot(snapshotId);
        }
        this.session.commit();
    }

    void purgeSnapshots(PurgeSnapshotQuery query) {
        this.purgeSnapshots(this.purgeMapper.selectSnapshotIds(query));
    }

    private void purgeSnapshots(List<Long> snapshotIds) {
        List<Long> characteristicIds;
        for (Long snapshotId : snapshotIds) {
            this.purgeMapper.deleteSnapshotDependencies(snapshotId);
        }
        this.session.commit();
        for (Long snapshotId : snapshotIds) {
            this.purgeMapper.deleteSnapshotDuplications(snapshotId);
        }
        this.session.commit();
        for (Long snapshotId : snapshotIds) {
            this.purgeMapper.deleteSnapshotSource(snapshotId);
        }
        this.session.commit();
        for (Long snapshotId : snapshotIds) {
            this.purgeMapper.deleteSnapshotViolations(snapshotId);
        }
        this.session.commit();
        List<Long> metricIdsWithoutHistoricalData = this.purgeMapper.selectMetricIdsWithoutHistoricalData();
        if (!metricIdsWithoutHistoricalData.isEmpty()) {
            for (Long snapshotId : snapshotIds) {
                this.purgeMapper.deleteSnapshotWastedMeasures(snapshotId, metricIdsWithoutHistoricalData);
            }
            this.session.commit();
        }
        if (!(characteristicIds = this.purgeMapper.selectCharacteristicIdsToPurge()).isEmpty()) {
            for (Long snapshotId : snapshotIds) {
                this.purgeMapper.deleteSnapshotMeasuresOnCharacteristics(snapshotId, characteristicIds);
            }
            this.session.commit();
        }
        for (Long snapshotId : snapshotIds) {
            this.purgeMapper.updatePurgeStatusToOne(snapshotId);
        }
        this.session.commit();
    }
}

