/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.plugins;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.core.plugins.DefaultPluginMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotePlugin {
    private String pluginKey;
    private List<String> filenames = Lists.newArrayList();
    private boolean core;

    public RemotePlugin(String pluginKey, boolean core) {
        this.pluginKey = pluginKey;
        this.core = core;
    }

    public static RemotePlugin create(DefaultPluginMetadata metadata) {
        RemotePlugin result = new RemotePlugin(metadata.getKey(), metadata.isCore());
        result.addFilename(metadata.getFile().getName());
        for (File file : metadata.getDeprecatedExtensions()) {
            result.addFilename(file.getName());
        }
        return result;
    }

    public static RemotePlugin unmarshal(String row) {
        String[] fields = StringUtils.split((String)row, (String)",");
        RemotePlugin result = new RemotePlugin(fields[0], Boolean.parseBoolean(fields[1]));
        if (fields.length > 2) {
            for (int index = 2; index < fields.length; ++index) {
                result.addFilename(fields[index]);
            }
        }
        return result;
    }

    public String marshal() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pluginKey).append(",");
        sb.append(String.valueOf(this.core));
        for (String filename : this.filenames) {
            sb.append(",").append(filename);
        }
        return sb.toString();
    }

    public String getKey() {
        return this.pluginKey;
    }

    public boolean isCore() {
        return this.core;
    }

    public RemotePlugin addFilename(String s) {
        this.filenames.add(s);
        return this;
    }

    public List<String> getFilenames() {
        return this.filenames;
    }

    public String getPluginFilename() {
        return !this.filenames.isEmpty() ? this.filenames.get(0) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemotePlugin that = (RemotePlugin)o;
        return this.pluginKey.equals(that.pluginKey);
    }

    public int hashCode() {
        return this.pluginKey.hashCode();
    }
}

