/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.plugins;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.platform.PluginMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginMetadata
implements PluginMetadata,
Comparable<PluginMetadata> {
    private File file;
    private List<File> deployedFiles = Lists.newArrayList();
    private List<File> deprecatedExtensions = Lists.newArrayList();
    private String[] pathsToInternalDeps = new String[0];
    private String key;
    private String version;
    private String name;
    private String mainClass;
    private String description;
    private String organization;
    private String organizationUrl;
    private String license;
    private String homepage;
    private boolean useChildFirstClassLoader;
    private String basePlugin;
    private boolean core;

    private DefaultPluginMetadata() {
    }

    public static DefaultPluginMetadata create(File file) {
        return new DefaultPluginMetadata().setFile(file);
    }

    public File getFile() {
        return this.file;
    }

    public DefaultPluginMetadata setFile(File file) {
        this.file = file;
        return this;
    }

    public List<File> getDeployedFiles() {
        return this.deployedFiles;
    }

    public DefaultPluginMetadata addDeployedFile(File f) {
        this.deployedFiles.add(f);
        return this;
    }

    public List<File> getDeprecatedExtensions() {
        return this.deprecatedExtensions;
    }

    public DefaultPluginMetadata addDeprecatedExtension(File f) {
        this.deprecatedExtensions.add(f);
        return this;
    }

    public DefaultPluginMetadata setDeprecatedExtensions(List<File> files) {
        this.deprecatedExtensions = files == null ? Lists.newArrayList() : files;
        return this;
    }

    public String[] getPathsToInternalDeps() {
        return this.pathsToInternalDeps;
    }

    public DefaultPluginMetadata setPathsToInternalDeps(String[] pathsToInternalDeps) {
        this.pathsToInternalDeps = pathsToInternalDeps;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public DefaultPluginMetadata setKey(String key) {
        this.key = key;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DefaultPluginMetadata setName(String name) {
        this.name = name;
        return this;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public DefaultPluginMetadata setMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public DefaultPluginMetadata setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getOrganization() {
        return this.organization;
    }

    public DefaultPluginMetadata setOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    public DefaultPluginMetadata setOrganizationUrl(String organizationUrl) {
        this.organizationUrl = organizationUrl;
        return this;
    }

    public String getLicense() {
        return this.license;
    }

    public DefaultPluginMetadata setLicense(String license) {
        this.license = license;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public DefaultPluginMetadata setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public DefaultPluginMetadata setHomepage(String homepage) {
        this.homepage = homepage;
        return this;
    }

    public boolean hasKey() {
        return StringUtils.isNotBlank((String)this.key);
    }

    public boolean hasMainClass() {
        return StringUtils.isNotBlank((String)this.mainClass);
    }

    public DefaultPluginMetadata setUseChildFirstClassLoader(boolean use) {
        this.useChildFirstClassLoader = use;
        return this;
    }

    public boolean isUseChildFirstClassLoader() {
        return this.useChildFirstClassLoader;
    }

    public DefaultPluginMetadata setBasePlugin(String key) {
        this.basePlugin = key;
        return this;
    }

    public String getBasePlugin() {
        return this.basePlugin;
    }

    public boolean isCore() {
        return this.core;
    }

    public DefaultPluginMetadata setCore(boolean b) {
        this.core = b;
        return this;
    }

    public boolean isOldManifest() {
        return !this.hasKey() && this.hasMainClass();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPluginMetadata that = (DefaultPluginMetadata)o;
        return !(this.key == null ? that.key != null : !this.key.equals(that.key));
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("key", (Object)this.key).append("version", (Object)StringUtils.defaultIfEmpty((String)this.version, (String)"-")).toString();
    }

    @Override
    public int compareTo(PluginMetadata other) {
        return this.name.compareTo(other.getName());
    }
}

