/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence.dialect;

import org.apache.commons.lang.StringUtils;
import org.hibernate.dialect.PostgreSQLDialect;
import org.sonar.core.persistence.dialect.Dialect;
import org.sonar.core.persistence.dialect.PostgreSQLSequenceGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreSql
implements Dialect {
    public static final String ID = "postgresql";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getActiveRecordDialectCode() {
        return "postgre";
    }

    @Override
    public String getActiveRecordJdbcAdapter() {
        return "jdbc";
    }

    @Override
    public Class<? extends org.hibernate.dialect.Dialect> getHibernateDialectClass() {
        return PostgreSQLWithDecimalDialect.class;
    }

    @Override
    public boolean matchesJdbcURL(String jdbcConnectionURL) {
        return StringUtils.startsWithIgnoreCase((String)jdbcConnectionURL, (String)"jdbc:postgresql:");
    }

    @Override
    public String getDefaultDriverClassName() {
        return "org.postgresql.Driver";
    }

    @Override
    public String getConnectionInitStatement(String schema) {
        if (StringUtils.isNotBlank((String)schema)) {
            return "SET SEARCH_PATH TO " + schema;
        }
        return null;
    }

    @Override
    public String getTrueSqlValue() {
        return "true";
    }

    @Override
    public String getFalseSqlValue() {
        return "false";
    }

    public static class PostgreSQLWithDecimalDialect
    extends PostgreSQLDialect {
        public PostgreSQLWithDecimalDialect() {
            this.registerColumnType(8, "numeric($p,$s)");
        }

        public Class getNativeIdentifierGeneratorClass() {
            return PostgreSQLSequenceGenerator.class;
        }
    }
}

