/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence.dialect;

import org.apache.commons.lang.StringUtils;
import org.hibernate.dialect.Oracle10gDialect;
import org.sonar.core.persistence.dialect.Dialect;
import org.sonar.core.persistence.dialect.OracleSequenceGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Oracle
implements Dialect {
    public static final String ID = "oracle";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getActiveRecordDialectCode() {
        return ID;
    }

    @Override
    public String getActiveRecordJdbcAdapter() {
        return "oracle_enhanced";
    }

    @Override
    public Class<? extends org.hibernate.dialect.Dialect> getHibernateDialectClass() {
        return Oracle10gWithDecimalDialect.class;
    }

    @Override
    public boolean matchesJdbcURL(String jdbcConnectionURL) {
        return StringUtils.startsWithIgnoreCase((String)jdbcConnectionURL, (String)"jdbc:oracle:");
    }

    @Override
    public String getDefaultDriverClassName() {
        return "oracle.jdbc.OracleDriver";
    }

    @Override
    public String getConnectionInitStatement(String schema) {
        if (StringUtils.isNotBlank((String)schema)) {
            return "ALTER SESSION SET CURRENT_SCHEMA = \"" + schema + "\"";
        }
        return null;
    }

    @Override
    public String getTrueSqlValue() {
        return "1";
    }

    @Override
    public String getFalseSqlValue() {
        return "0";
    }

    public static class Oracle10gWithDecimalDialect
    extends Oracle10gDialect {
        public Oracle10gWithDecimalDialect() {
            this.registerColumnType(8, "number($p,$s)");
            this.registerColumnType(12, 0xFFFFFF, "clob");
            this.registerColumnType(-3, "blob");
        }

        public Class getNativeIdentifierGeneratorClass() {
            return OracleSequenceGenerator.class;
        }
    }
}

