/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence.dialect;

import org.apache.commons.lang.StringUtils;
import org.hibernate.dialect.MySQLDialect;
import org.sonar.core.persistence.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySql
implements Dialect {
    public static final String ID = "mysql";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getActiveRecordDialectCode() {
        return ID;
    }

    @Override
    public String getActiveRecordJdbcAdapter() {
        return "jdbc";
    }

    @Override
    public Class<? extends org.hibernate.dialect.Dialect> getHibernateDialectClass() {
        return MySqlWithDecimalDialect.class;
    }

    @Override
    public boolean matchesJdbcURL(String jdbcConnectionURL) {
        return StringUtils.startsWithIgnoreCase((String)jdbcConnectionURL, (String)"jdbc:mysql:");
    }

    @Override
    public String getDefaultDriverClassName() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    public String getConnectionInitStatement(String schema) {
        return null;
    }

    @Override
    public String getTrueSqlValue() {
        return "true";
    }

    @Override
    public String getFalseSqlValue() {
        return "false";
    }

    public static class MySqlWithDecimalDialect
    extends MySQLDialect {
        public MySqlWithDecimalDialect() {
            this.registerColumnType(8, "decimal precision");
            this.registerColumnType(12, 0xFFFFFF, "mediumtext");
            this.registerColumnType(2005, "mediumtext");
            this.registerColumnType(2004, "blob");
        }
    }
}

