/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence.dialect;

import org.apache.commons.lang.StringUtils;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.id.IdentityGenerator;
import org.sonar.core.persistence.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Derby
implements Dialect {
    public static final String ID = "derby";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getActiveRecordDialectCode() {
        return ID;
    }

    @Override
    public String getActiveRecordJdbcAdapter() {
        return "jdbc";
    }

    @Override
    public Class<? extends org.hibernate.dialect.Dialect> getHibernateDialectClass() {
        return DerbyWithDecimalDialect.class;
    }

    @Override
    public boolean matchesJdbcURL(String jdbcConnectionURL) {
        return StringUtils.startsWithIgnoreCase((String)jdbcConnectionURL, (String)"jdbc:derby:");
    }

    @Override
    public String getDefaultDriverClassName() {
        return "org.apache.derby.jdbc.ClientDriver";
    }

    @Override
    public String getConnectionInitStatement(String schema) {
        return null;
    }

    @Override
    public String getTrueSqlValue() {
        return "true";
    }

    @Override
    public String getFalseSqlValue() {
        return "false";
    }

    public static class DerbyWithDecimalDialect
    extends DerbyDialect {
        public DerbyWithDecimalDialect() {
            this.registerColumnType(8, "decimal");
            this.registerColumnType(12, 0xFFFFFF, "clob");
            this.registerColumnType(-3, "blob");
            this.registerColumnType(-5, "integer");
            this.registerColumnType(-7, "boolean");
        }

        public String toBooleanValueString(boolean bool) {
            return bool ? "true" : "false";
        }

        public Class getNativeIdentifierGeneratorClass() {
            return IdentityGenerator.class;
        }
    }
}

