/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.core.dashboard.ActiveDashboardDto;
import org.sonar.core.dashboard.ActiveDashboardMapper;
import org.sonar.core.dashboard.DashboardDto;
import org.sonar.core.dashboard.DashboardMapper;
import org.sonar.core.dashboard.WidgetDto;
import org.sonar.core.dashboard.WidgetMapper;
import org.sonar.core.dashboard.WidgetPropertyDto;
import org.sonar.core.dashboard.WidgetPropertyMapper;
import org.sonar.core.duplication.DuplicationMapper;
import org.sonar.core.duplication.DuplicationUnitDto;
import org.sonar.core.filter.CriterionDto;
import org.sonar.core.filter.CriterionMapper;
import org.sonar.core.filter.FilterColumnDto;
import org.sonar.core.filter.FilterColumnMapper;
import org.sonar.core.filter.FilterDto;
import org.sonar.core.filter.FilterMapper;
import org.sonar.core.persistence.BatchSession;
import org.sonar.core.persistence.Database;
import org.sonar.core.persistence.SchemaMigrationDto;
import org.sonar.core.persistence.SchemaMigrationMapper;
import org.sonar.core.properties.PropertiesMapper;
import org.sonar.core.properties.PropertyDto;
import org.sonar.core.purge.PurgeMapper;
import org.sonar.core.purge.PurgeVendorMapper;
import org.sonar.core.purge.PurgeableSnapshotDto;
import org.sonar.core.resource.ResourceDto;
import org.sonar.core.resource.ResourceIndexDto;
import org.sonar.core.resource.ResourceIndexerMapper;
import org.sonar.core.resource.ResourceMapper;
import org.sonar.core.resource.SnapshotDto;
import org.sonar.core.review.ReviewCommentDto;
import org.sonar.core.review.ReviewCommentMapper;
import org.sonar.core.review.ReviewDto;
import org.sonar.core.review.ReviewMapper;
import org.sonar.core.rule.RuleDto;
import org.sonar.core.rule.RuleMapper;
import org.sonar.core.template.LoadedTemplateDto;
import org.sonar.core.template.LoadedTemplateMapper;
import org.sonar.core.user.AuthorDto;
import org.sonar.core.user.AuthorMapper;

public class MyBatis
implements BatchComponent,
ServerComponent {
    private final Database database;
    private SqlSessionFactory sessionFactory;

    public MyBatis(Database database) {
        this.database = database;
    }

    public MyBatis start() {
        LogFactory.useSlf4jLogging();
        Configuration conf = new Configuration();
        conf.setEnvironment(new Environment("production", (TransactionFactory)MyBatis.createTransactionFactory(), this.database.getDataSource()));
        conf.setUseGeneratedKeys(true);
        conf.setLazyLoadingEnabled(false);
        conf.getVariables().setProperty("_true", this.database.getDialect().getTrueSqlValue());
        conf.getVariables().setProperty("_false", this.database.getDialect().getFalseSqlValue());
        this.loadAlias(conf, "ActiveDashboard", ActiveDashboardDto.class);
        this.loadAlias(conf, "Author", AuthorDto.class);
        this.loadAlias(conf, "Filter", FilterDto.class);
        this.loadAlias(conf, "Criterion", CriterionDto.class);
        this.loadAlias(conf, "FilterColumn", FilterColumnDto.class);
        this.loadAlias(conf, "Dashboard", DashboardDto.class);
        this.loadAlias(conf, "DuplicationUnit", DuplicationUnitDto.class);
        this.loadAlias(conf, "LoadedTemplate", LoadedTemplateDto.class);
        this.loadAlias(conf, "Property", PropertyDto.class);
        this.loadAlias(conf, "PurgeableSnapshot", PurgeableSnapshotDto.class);
        this.loadAlias(conf, "Review", ReviewDto.class);
        this.loadAlias(conf, "ReviewComment", ReviewCommentDto.class);
        this.loadAlias(conf, "Resource", ResourceDto.class);
        this.loadAlias(conf, "ResourceIndex", ResourceIndexDto.class);
        this.loadAlias(conf, "Rule", RuleDto.class);
        this.loadAlias(conf, "Snapshot", SnapshotDto.class);
        this.loadAlias(conf, "SchemaMigration", SchemaMigrationDto.class);
        this.loadAlias(conf, "Widget", WidgetDto.class);
        this.loadAlias(conf, "WidgetProperty", WidgetPropertyDto.class);
        this.loadMapper(conf, ActiveDashboardMapper.class);
        this.loadMapper(conf, AuthorMapper.class);
        this.loadMapper(conf, FilterMapper.class);
        this.loadMapper(conf, CriterionMapper.class);
        this.loadMapper(conf, FilterColumnMapper.class);
        this.loadMapper(conf, DashboardMapper.class);
        this.loadMapper(conf, DuplicationMapper.class);
        this.loadMapper(conf, LoadedTemplateMapper.class);
        this.loadMapper(conf, PropertiesMapper.class);
        this.loadMapper(conf, PurgeMapper.class);
        this.loadMapper(conf, PurgeVendorMapper.class);
        this.loadMapper(conf, ResourceMapper.class);
        this.loadMapper(conf, ReviewCommentMapper.class);
        this.loadMapper(conf, ReviewMapper.class);
        this.loadMapper(conf, ResourceIndexerMapper.class);
        this.loadMapper(conf, RuleMapper.class);
        this.loadMapper(conf, SchemaMigrationMapper.class);
        this.loadMapper(conf, WidgetMapper.class);
        this.loadMapper(conf, WidgetPropertyMapper.class);
        this.sessionFactory = new SqlSessionFactoryBuilder().build(conf);
        return this;
    }

    public SqlSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public SqlSession openSession() {
        return this.sessionFactory.openSession(ExecutorType.REUSE);
    }

    public BatchSession openBatchSession() {
        SqlSession session = this.sessionFactory.openSession(ExecutorType.BATCH);
        return new BatchSession(session);
    }

    public static void closeQuietly(SqlSession session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(MyBatis.class).warn("Fail to close session", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMapper(Configuration conf, Class mapperClass) {
        InputStream input = this.getPathToMapper(mapperClass);
        try {
            XMLMapperBuilder mapperParser = new XMLMapperBuilder(input, conf, mapperClass.getName(), conf.getSqlFragments());
            mapperParser.parse();
            conf.addLoadedResource(mapperClass.getName());
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    private InputStream getPathToMapper(Class mapperClass) {
        InputStream input = this.getClass().getResourceAsStream("/" + StringUtils.replace((String)mapperClass.getName(), (String)".", (String)"/") + "-" + this.database.getDialect().getId() + ".xml");
        if (input == null) {
            input = this.getClass().getResourceAsStream("/" + StringUtils.replace((String)mapperClass.getName(), (String)".", (String)"/") + ".xml");
        }
        return input;
    }

    private void loadAlias(Configuration conf, String alias, Class dtoClass) {
        conf.getTypeAliasRegistry().registerAlias(alias, dtoClass);
    }

    private static JdbcTransactionFactory createTransactionFactory() {
        return new JdbcTransactionFactory();
    }
}

