/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import org.apache.commons.io.output.NullWriter;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;

public final class DdlUtils {
    private DdlUtils() {
    }

    public static boolean supportsDialect(String dialect) {
        return "derby".equals(dialect);
    }

    public static void createSchema(Connection connection, String dialect) {
        DdlUtils.executeScript(connection, "org/sonar/core/persistence/schema-" + dialect + ".ddl");
        DdlUtils.executeScript(connection, "org/sonar/core/persistence/rows-" + dialect + ".sql");
    }

    private static void executeScript(Connection connection, String path) {
        ScriptRunner scriptRunner = DdlUtils.newScriptRunner(connection);
        try {
            scriptRunner.runScript(Resources.getResourceAsReader((String)path));
            connection.commit();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to restore: " + path, e);
        }
    }

    private static ScriptRunner newScriptRunner(Connection connection) {
        ScriptRunner scriptRunner = new ScriptRunner(connection);
        scriptRunner.setDelimiter(";");
        scriptRunner.setStopOnError(true);
        scriptRunner.setLogWriter(new PrintWriter((Writer)new NullWriter()));
        return scriptRunner;
    }
}

