/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.persistence.SchemaMigrationMapper;
import org.sonar.core.properties.PropertiesMapper;
import org.sonar.core.properties.PropertyDto;

public class DatabaseVersion
implements BatchComponent,
ServerComponent {
    public static final int LAST_VERSION = 306;
    private MyBatis mybatis;

    public DatabaseVersion(MyBatis mybatis) {
        this.mybatis = mybatis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        SqlSession session = this.mybatis.openSession();
        try {
            List<Integer> versions = ((SchemaMigrationMapper)session.getMapper(SchemaMigrationMapper.class)).selectVersions();
            if (!versions.isEmpty()) {
                Collections.sort(versions);
                Integer n = versions.get(versions.size() - 1);
                return n;
            }
            Integer n = null;
            return n;
        }
        catch (RuntimeException e) {
            Integer n = null;
            return n;
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSonarCoreId() {
        SqlSession session = this.mybatis.openSession();
        try {
            PropertyDto serverIdProperty = ((PropertiesMapper)session.getMapper(PropertiesMapper.class)).selectByKey(new PropertyDto().setKey("sonar.core.id"));
            String string = serverIdProperty.getValue();
            return string;
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }

    public Status getStatus() {
        return DatabaseVersion.getStatus(this.getVersion(), 306);
    }

    @VisibleForTesting
    static Status getStatus(Integer currentVersion, int lastVersion) {
        Status status = Status.FRESH_INSTALL;
        if (currentVersion != null) {
            status = currentVersion == lastVersion ? Status.UP_TO_DATE : (currentVersion > lastVersion ? Status.REQUIRES_DOWNGRADE : Status.REQUIRES_UPGRADE);
        }
        return status;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UP_TO_DATE,
        REQUIRES_UPGRADE,
        REQUIRES_DOWNGRADE,
        FRESH_INSTALL;

    }
}

