/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import java.sql.Connection;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.LoggerFactory;
import org.sonar.api.ServerComponent;
import org.sonar.core.persistence.Database;
import org.sonar.core.persistence.DdlUtils;
import org.sonar.core.persistence.MyBatis;

public class DatabaseMigrator
implements ServerComponent {
    private MyBatis myBatis;
    private Database database;

    public DatabaseMigrator(MyBatis myBatis, Database database) {
        this.myBatis = myBatis;
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createDatabase() {
        if (DdlUtils.supportsDialect(this.database.getDialect().getId())) {
            LoggerFactory.getLogger(this.getClass()).info("Create database");
            SqlSession session = this.myBatis.openSession();
            Connection connection = session.getConnection();
            try {
                DdlUtils.createSchema(connection, this.database.getDialect().getId());
            }
            finally {
                try {
                    MyBatis.closeQuietly(session);
                    connection.close();
                }
                catch (Exception exception) {}
            }
            return true;
        }
        return false;
    }
}

