/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchSession
implements SqlSession {
    public static final int MAX_BATCH_SIZE = 250;
    private final SqlSession session;
    private final int batchSize;
    private int count = 0;

    BatchSession(SqlSession session) {
        this(session, 250);
    }

    BatchSession(SqlSession session, int batchSize) {
        this.session = session;
        this.batchSize = batchSize;
    }

    public void select(String statement, Object parameter, ResultHandler handler) {
        this.reset();
        this.session.select(statement, parameter, handler);
    }

    public void select(String statement, ResultHandler handler) {
        this.reset();
        this.session.select(statement, handler);
    }

    public Object selectOne(String statement) {
        this.reset();
        return this.session.selectOne(statement);
    }

    public Object selectOne(String statement, Object parameter) {
        this.reset();
        return this.session.selectOne(statement, parameter);
    }

    public List selectList(String statement) {
        this.reset();
        return this.session.selectList(statement);
    }

    public List selectList(String statement, Object parameter) {
        this.reset();
        return this.session.selectList(statement, parameter);
    }

    public List selectList(String statement, Object parameter, RowBounds rowBounds) {
        this.reset();
        return this.session.selectList(statement, parameter, rowBounds);
    }

    public Map selectMap(String statement, String mapKey) {
        this.reset();
        return this.session.selectMap(statement, mapKey);
    }

    public Map selectMap(String statement, Object parameter, String mapKey) {
        this.reset();
        return this.session.selectMap(statement, parameter, mapKey);
    }

    public Map selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        this.reset();
        return this.session.selectMap(statement, parameter, mapKey, rowBounds);
    }

    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        this.reset();
        this.session.select(statement, parameter, rowBounds, handler);
    }

    public int insert(String statement) {
        this.increment();
        return this.session.insert(statement);
    }

    public int insert(String statement, Object parameter) {
        this.increment();
        return this.session.insert(statement, parameter);
    }

    public int update(String statement) {
        this.increment();
        return this.session.update(statement);
    }

    public int update(String statement, Object parameter) {
        this.increment();
        return this.session.update(statement, parameter);
    }

    public int delete(String statement) {
        this.increment();
        return this.session.delete(statement);
    }

    public int delete(String statement, Object parameter) {
        this.increment();
        return this.session.delete(statement, parameter);
    }

    public void commit() {
        this.session.commit();
        this.reset();
    }

    public void commit(boolean force) {
        this.session.commit(force);
        this.reset();
    }

    public void rollback() {
        this.session.rollback();
        this.reset();
    }

    public void rollback(boolean force) {
        this.session.rollback(force);
        this.reset();
    }

    public List<BatchResult> flushStatements() {
        List batchResults = this.session.flushStatements();
        this.reset();
        return batchResults;
    }

    public void close() {
        this.session.close();
    }

    public void clearCache() {
        this.session.clearCache();
    }

    public Configuration getConfiguration() {
        return this.session.getConfiguration();
    }

    public <T> T getMapper(Class<T> type) {
        return (T)this.getConfiguration().getMapper(type, (SqlSession)this);
    }

    public Connection getConnection() {
        return this.session.getConnection();
    }

    private BatchSession increment() {
        ++this.count;
        if (this.count >= this.batchSize) {
            this.commit();
        }
        return this;
    }

    private void reset() {
        this.count = 0;
    }
}

