/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.notification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.notifications.Notification;
import org.sonar.api.utils.SonarException;

@Entity
@Table(name="notifications")
public class NotificationQueueElement {
    @Id
    @Column(name="id")
    @GeneratedValue
    private Integer id;
    @Column(name="created_at")
    private Date createdAt;
    @Column(name="data", updatable=true, nullable=true, length=0x9FFFFF6)
    private byte[] data;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setNotification(Notification notification) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(notification);
            objectOutputStream.close();
            this.data = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Notification getNotification() {
        Notification notification;
        if (this.data == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(this.data);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object result = objectInputStream.readObject();
            objectInputStream.close();
            notification = (Notification)result;
        }
        catch (IOException e) {
            try {
                throw new SonarException((Throwable)e);
                catch (ClassNotFoundException e2) {
                    throw new SonarException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(byteArrayInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)byteArrayInputStream);
        return notification;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }
}

