/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.metric;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.jpa.session.DatabaseSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMetricFinder
implements MetricFinder {
    private DatabaseSessionFactory sessionFactory;

    public DefaultMetricFinder(DatabaseSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Metric findById(int id) {
        return (Metric)this.sessionFactory.getSession().getSingleResult(Metric.class, new Object[]{"id", id, "enabled", true});
    }

    public Metric findByKey(String key) {
        return (Metric)this.sessionFactory.getSession().getSingleResult(Metric.class, new Object[]{"key", key, "enabled", true});
    }

    public Collection<Metric> findAll(List<String> metricKeys) {
        LinkedList result = Lists.newLinkedList();
        for (String metricKey : metricKeys) {
            Metric metric = this.findByKey(metricKey);
            if (metric == null) continue;
            result.add(metric);
        }
        return result;
    }

    public Collection<Metric> findAll() {
        return this.doFindAll();
    }

    protected Collection<Metric> doFindAll() {
        return this.sessionFactory.getSession().getResults(Metric.class, new Object[]{"enabled", true});
    }
}

