/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.metric;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sonar.api.measures.Metric;
import org.sonar.core.metric.DefaultMetricFinder;
import org.sonar.jpa.session.DatabaseSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CacheMetricFinder
extends DefaultMetricFinder {
    private Map<String, Metric> metricsByKey = Maps.newLinkedHashMap();
    private Map<Integer, Metric> metricsById = Maps.newLinkedHashMap();

    public CacheMetricFinder(DatabaseSessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public void start() {
        Collection<Metric> metrics = this.doFindAll();
        for (Metric metric : metrics) {
            this.metricsByKey.put(metric.getKey(), metric);
            this.metricsById.put(metric.getId(), metric);
        }
    }

    @Override
    public Metric findById(int metricId) {
        return this.metricsById.get(metricId);
    }

    @Override
    public Metric findByKey(String key) {
        return this.metricsByKey.get(key);
    }

    @Override
    public Collection<Metric> findAll(List<String> metricKeys) {
        LinkedList result = Lists.newLinkedList();
        for (String metricKey : metricKeys) {
            Metric metric = this.findByKey(metricKey);
            if (metric == null) continue;
            result.add(metric);
        }
        return result;
    }

    @Override
    public Collection<Metric> findAll() {
        return this.metricsByKey.values();
    }
}

