/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.i18n;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.ServerComponent;
import org.sonar.core.i18n.I18nManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleI18nManager
implements ServerComponent {
    private static final String NAME_SUFFIX = ".name";
    private static final String RULE_PREFIX = "rule.";
    private I18nManager i18nManager;
    private RuleKey[] ruleKeys;

    public RuleI18nManager(I18nManager i18nManager) {
        this.i18nManager = i18nManager;
    }

    public void start() {
        ArrayList list = Lists.newArrayList();
        for (String propertyKey : this.i18nManager.getPropertyKeys()) {
            if (!RuleI18nManager.isRuleProperty(propertyKey)) continue;
            list.add(RuleI18nManager.extractRuleKey(propertyKey));
        }
        this.ruleKeys = list.toArray(new RuleKey[list.size()]);
    }

    public String getName(String repositoryKey, String ruleKey, Locale locale) {
        return this.message(repositoryKey, ruleKey, locale, NAME_SUFFIX);
    }

    public String getDescription(String repositoryKey, String ruleKey, Locale locale) {
        String relatedProperty = RULE_PREFIX + repositoryKey + "." + ruleKey + NAME_SUFFIX;
        Locale localeWithoutCountry = locale.getCountry() == null ? locale : new Locale(locale.getLanguage());
        String ruleDescriptionFilePath = "rules/" + repositoryKey + "/" + ruleKey + ".html";
        String description = this.i18nManager.messageFromFile(localeWithoutCountry, ruleDescriptionFilePath, relatedProperty, true);
        if (description == null && (description = this.lookUpDescriptionInFormerLocation(ruleKey, relatedProperty, localeWithoutCountry)) == null && !"en".equals(localeWithoutCountry.getLanguage())) {
            description = this.i18nManager.messageFromFile(Locale.ENGLISH, ruleDescriptionFilePath, relatedProperty, true);
        }
        return description;
    }

    private String lookUpDescriptionInFormerLocation(String ruleKey, String relatedProperty, Locale localeWithoutCountry) {
        String description = this.i18nManager.messageFromFile(localeWithoutCountry, ruleKey + ".html", relatedProperty, true);
        if (description == null && !"en".equals(localeWithoutCountry.getLanguage())) {
            description = this.i18nManager.messageFromFile(Locale.ENGLISH, ruleKey + ".html", relatedProperty, true);
        }
        return description;
    }

    public String getParamDescription(String repositoryKey, String ruleKey, String paramKey, Locale locale) {
        return this.message(repositoryKey, ruleKey, locale, ".param." + paramKey);
    }

    String message(String repositoryKey, String ruleKey, Locale locale, String suffix) {
        String propertyKey = RULE_PREFIX + repositoryKey + "." + ruleKey + suffix;
        return this.i18nManager.message(locale, propertyKey, null, new Object[0]);
    }

    public List<RuleKey> searchNames(String search, Locale locale) {
        ArrayList result = Lists.newArrayList();
        for (RuleKey ruleKey : this.ruleKeys) {
            String name = this.i18nManager.message(locale, ruleKey.getNameProperty(), null, new Object[0]);
            if (name == null || StringUtils.indexOfIgnoreCase((String)name, (String)search) < 0) continue;
            result.add(ruleKey);
        }
        return result;
    }

    RuleKey[] getRuleKeys() {
        return this.ruleKeys;
    }

    static RuleKey extractRuleKey(String propertyKey) {
        String s = StringUtils.substringBetween((String)propertyKey, (String)RULE_PREFIX, (String)NAME_SUFFIX);
        String ruleKey = StringUtils.substringAfter((String)s, (String)".");
        String repository = StringUtils.substringBefore((String)s, (String)".");
        return new RuleKey(repository, ruleKey);
    }

    static boolean isRuleProperty(String propertyKey) {
        return StringUtils.startsWith((String)propertyKey, (String)RULE_PREFIX) && StringUtils.endsWith((String)propertyKey, (String)NAME_SUFFIX) && !propertyKey.contains(".param.");
    }

    public static class RuleKey {
        private String repositoryKey;
        private String key;

        RuleKey(String repositoryKey, String key) {
            this.repositoryKey = repositoryKey;
            this.key = key;
        }

        public String getRepositoryKey() {
            return this.repositoryKey;
        }

        public String getKey() {
            return this.key;
        }

        public String getNameProperty() {
            return RuleI18nManager.RULE_PREFIX + this.repositoryKey + "." + this.key + RuleI18nManager.NAME_SUFFIX;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuleKey ruleKey = (RuleKey)o;
            if (!this.key.equals(ruleKey.key)) {
                return false;
            }
            return this.repositoryKey.equals(ruleKey.repositoryKey);
        }

        public int hashCode() {
            int result = this.repositoryKey.hashCode();
            result = 31 * result + this.key.hashCode();
            return result;
        }

        public String toString() {
            return this.repositoryKey + ":" + this.key;
        }
    }
}

