/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.filter;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.sonar.core.filter.CriterionDto;
import org.sonar.core.filter.FilterColumnDto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterDto {
    private Long id;
    private Long userId;
    private String defaultView;
    private Boolean favourites;
    private String key;
    private String name;
    private Long pageSize;
    private Long periodIndex;
    private Long resourceId;
    private Boolean shared;
    private List<CriterionDto> criteria = Lists.newArrayList();
    private List<FilterColumnDto> filterColumns = Lists.newArrayList();

    public FilterDto add(CriterionDto criterion) {
        this.criteria.add(criterion);
        return this;
    }

    public FilterDto add(FilterColumnDto filterColumn) {
        this.filterColumns.add(filterColumn);
        return this;
    }

    public Collection<FilterColumnDto> getColumns() {
        return this.filterColumns;
    }

    public Collection<CriterionDto> getCriteria() {
        return this.criteria;
    }

    public String getDefaultView() {
        return this.defaultView;
    }

    public Boolean getFavourites() {
        return this.favourites;
    }

    public List<FilterColumnDto> getFilterColumns() {
        return this.filterColumns;
    }

    public Long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public Long getPeriodIndex() {
        return this.periodIndex;
    }

    public Long getResourceId() {
        return this.resourceId;
    }

    public Boolean getShared() {
        return this.shared;
    }

    public Long getUserId() {
        return this.userId;
    }

    public Boolean isFavourites() {
        return this.favourites;
    }

    public Boolean isShared() {
        return this.shared;
    }

    public FilterDto setDefaultView(String defaultView) {
        this.defaultView = defaultView;
        return this;
    }

    public FilterDto setFavourites(Boolean favourites) {
        this.favourites = favourites;
        return this;
    }

    public FilterDto setKey(String key) {
        this.key = key;
        return this;
    }

    public FilterDto setName(String name) {
        this.name = name;
        return this;
    }

    public FilterDto setPageSize(Long pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public FilterDto setShared(Boolean shared) {
        this.shared = shared;
        return this;
    }
}

