/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.filter;

import org.apache.ibatis.session.SqlSession;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.core.filter.CriterionDto;
import org.sonar.core.filter.CriterionMapper;
import org.sonar.core.filter.FilterColumnDto;
import org.sonar.core.filter.FilterColumnMapper;
import org.sonar.core.filter.FilterDto;
import org.sonar.core.filter.FilterMapper;
import org.sonar.core.persistence.MyBatis;

public class FilterDao
implements BatchComponent,
ServerComponent {
    private MyBatis mybatis;

    public FilterDao(MyBatis mybatis) {
        this.mybatis = mybatis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterDto findFilter(String name) {
        SqlSession session = this.mybatis.openSession();
        try {
            FilterMapper mapper = (FilterMapper)session.getMapper(FilterMapper.class);
            FilterDto filterDto = mapper.findFilter(name);
            return filterDto;
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(FilterDto filterDto) {
        SqlSession session = this.mybatis.openSession();
        FilterMapper filterMapper = (FilterMapper)session.getMapper(FilterMapper.class);
        CriterionMapper criteriaMapper = (CriterionMapper)session.getMapper(CriterionMapper.class);
        FilterColumnMapper columnMapper = (FilterColumnMapper)session.getMapper(FilterColumnMapper.class);
        try {
            filterMapper.insert(filterDto);
            for (CriterionDto criteriaDto : filterDto.getCriteria()) {
                criteriaDto.setFilterId(filterDto.getId());
                criteriaMapper.insert(criteriaDto);
            }
            for (FilterColumnDto filterColumnDto : filterDto.getColumns()) {
                filterColumnDto.setFilterId(filterDto.getId());
                columnMapper.insert(filterColumnDto);
            }
            session.commit();
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }
}

