/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.database.configuration;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.database.BaseIdentifiable;

@Entity
@Table(name="properties")
public class Property
extends BaseIdentifiable {
    @Column(name="prop_key", updatable=true, nullable=true)
    private String key;
    @Column(name="text_value", updatable=true, nullable=true, length=0x9FFFFF6)
    @Lob
    private char[] value;
    @Column(name="resource_id", updatable=true, nullable=true)
    private Integer resourceId;
    @Column(name="user_id", updatable=true, nullable=true)
    private Integer userId;

    public Property(String key, String value) {
        this(key, value, null);
    }

    public Property(String key, String value, Integer resourceId) {
        this.key = key;
        this.value = (char[])(value != null ? value.toCharArray() : null);
        this.resourceId = resourceId;
    }

    public Property() {
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        if (this.value != null) {
            return new String(this.value);
        }
        return null;
    }

    public void setValue(String value) {
        this.value = (char[])(value != null ? value.toCharArray() : null);
    }

    public Integer getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public Property setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)((Object)o);
        if (!this.key.equals(property.key)) {
            return false;
        }
        if (this.resourceId != null ? !this.resourceId.equals(property.resourceId) : property.resourceId != null) {
            return false;
        }
        return !(this.userId == null ? property.userId != null : !this.userId.equals(property.userId));
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (this.resourceId != null ? this.resourceId.hashCode() : 0);
        result = 31 * result + (this.userId != null ? this.userId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }
}

