/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.session;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.Logs;
import org.sonar.core.persistence.Database;
import org.sonar.core.persistence.dialect.Dialect;
import org.sonar.jpa.entity.SchemaMigration;
import org.sonar.jpa.session.DatabaseConnector;
import org.sonar.jpa.session.DatabaseException;

public abstract class AbstractDatabaseConnector
implements DatabaseConnector {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractDatabaseConnector.class);
    protected Database database;
    private EntityManagerFactory factory = null;
    private int databaseVersion = -1;
    private boolean operational = false;
    private boolean started = false;

    protected AbstractDatabaseConnector(Database database) {
        this.database = database;
    }

    public String getDialectId() {
        return this.database.getDialect().getId();
    }

    public boolean isOperational() {
        return this.operational;
    }

    protected boolean isStarted() {
        return this.started;
    }

    public void start() {
        boolean upToDate;
        if (!this.started) {
            this.testConnection();
            this.started = true;
        }
        if (!this.operational && (upToDate = this.upToDateSchemaVersion())) {
            Logs.INFO.info("Initializing Hibernate");
            this.factory = this.createEntityManagerFactory();
            this.operational = true;
        }
    }

    public void stop() {
        if (this.factory != null && this.factory.isOpen()) {
            this.factory.close();
            this.factory = null;
        }
        this.operational = false;
        this.started = false;
        this.database = null;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.factory;
    }

    protected void setEntityManagerFactory(EntityManagerFactory factory) {
        this.factory = factory;
    }

    protected EntityManagerFactory createEntityManagerFactory() {
        Properties props = this.database.getHibernateProperties();
        this.logHibernateSettings(props);
        return Persistence.createEntityManagerFactory((String)"sonar", (Map)props);
    }

    private void logHibernateSettings(Properties props) {
        if (LOG.isDebugEnabled()) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                LOG.debug(entry.getKey() + ": " + entry.getValue());
            }
        }
    }

    public EntityManager createEntityManager() {
        return this.factory.createEntityManager();
    }

    private String testConnection() throws DatabaseException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            String string = connection.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new DatabaseException("Cannot open connection to database: " + e.getMessage(), e);
        }
        finally {
            this.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int loadVersion() {
        Connection connection = null;
        try {
            connection = this.getConnection();
            int n = SchemaMigration.getCurrentVersion(connection);
            return n;
        }
        catch (SQLException e) {
            int n = 0;
            return n;
        }
        finally {
            this.close(connection);
        }
    }

    private void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected boolean upToDateSchemaVersion() {
        if (this.databaseVersion == 241) {
            return true;
        }
        this.databaseVersion = this.loadVersion();
        return this.databaseVersion == 241;
    }

    public final int getDatabaseVersion() {
        return this.databaseVersion;
    }

    public final Dialect getDialect() {
        return this.database.getDialect();
    }
}

