/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.review;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReviewQuery {
    private Boolean manualViolation;
    private Boolean manualSeverity;
    private Integer resourceId;
    private Integer userId;
    private List<Integer> violationPermanentIds;
    private Integer ruleId;
    private String status;
    private String resolution;

    private ReviewQuery() {
    }

    private ReviewQuery(ReviewQuery other, List<Integer> permanentIds) {
        this.manualViolation = other.manualViolation;
        this.manualSeverity = other.manualSeverity;
        this.resourceId = other.resourceId;
        this.userId = other.userId;
        this.violationPermanentIds = permanentIds;
        this.ruleId = other.ruleId;
        this.status = other.status;
        this.resolution = other.resolution;
    }

    public static ReviewQuery create() {
        return new ReviewQuery();
    }

    public Boolean getManualViolation() {
        return this.manualViolation;
    }

    public ReviewQuery setManualViolation(Boolean manualViolation) {
        this.manualViolation = manualViolation;
        return this;
    }

    public Integer getResourceId() {
        return this.resourceId;
    }

    public ReviewQuery setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public ReviewQuery setStatus(String status) {
        this.status = status;
        return this;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public ReviewQuery setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    public Collection<Integer> getViolationPermanentIds() {
        return this.violationPermanentIds;
    }

    public ReviewQuery setViolationPermanentIds(List<Integer> l) {
        this.violationPermanentIds = l;
        return this;
    }

    public Integer getRuleId() {
        return this.ruleId;
    }

    public ReviewQuery setRuleId(Integer ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    public String getResolution() {
        return this.resolution;
    }

    public ReviewQuery setResolution(String resolution) {
        this.resolution = resolution;
        return this;
    }

    public Boolean getManualSeverity() {
        return this.manualSeverity;
    }

    public ReviewQuery setManualSeverity(boolean b) {
        this.manualSeverity = b;
        return this;
    }

    boolean needToPartitionQuery() {
        return this.violationPermanentIds != null && this.violationPermanentIds.size() > 1000;
    }

    ReviewQuery[] partition() {
        List partitions = Lists.partition(this.violationPermanentIds, (int)1000);
        ReviewQuery[] result = new ReviewQuery[partitions.size()];
        for (int index = 0; index < partitions.size(); ++index) {
            result[index] = new ReviewQuery(this, (List)partitions.get(index));
        }
        return result;
    }
}

