/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.review;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.review.ReviewDto;
import org.sonar.core.review.ReviewMapper;
import org.sonar.core.review.ReviewQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewDao
implements BatchComponent,
ServerComponent {
    private final MyBatis mybatis;

    public ReviewDao(MyBatis mybatis) {
        this.mybatis = mybatis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReviewDto selectById(long id) {
        SqlSession sqlSession = this.mybatis.openSession();
        try {
            ReviewMapper mapper = (ReviewMapper)sqlSession.getMapper(ReviewMapper.class);
            ReviewDto reviewDto = mapper.selectById(id);
            return reviewDto;
        }
        finally {
            sqlSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReviewDto> selectByResource(int resourceId) {
        SqlSession sqlSession = this.mybatis.openSession();
        try {
            ReviewMapper mapper = (ReviewMapper)sqlSession.getMapper(ReviewMapper.class);
            List<ReviewDto> list = mapper.selectByResource(resourceId);
            return list;
        }
        finally {
            sqlSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReviewDto> selectByQuery(ReviewQuery query) {
        SqlSession sqlSession = this.mybatis.openSession();
        try {
            List<Object> result;
            ReviewMapper mapper = (ReviewMapper)sqlSession.getMapper(ReviewMapper.class);
            if (query.needToPartitionQuery()) {
                result = Lists.newArrayList();
                for (ReviewQuery partitionedQuery : query.partition()) {
                    result.addAll(mapper.selectByQuery(partitionedQuery));
                }
            } else {
                result = mapper.selectByQuery(query);
            }
            List<Object> list = result;
            return list;
        }
        finally {
            sqlSession.close();
        }
    }
}

