/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.resource;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.SqlSession;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.resource.ResourceDto;
import org.sonar.core.resource.ResourceIndexDto;
import org.sonar.core.resource.ResourceIndexerMapper;
import org.sonar.core.resource.ResourceIndexerQuery;

public class ResourceIndexerDao {
    public static final int MINIMUM_KEY_SIZE = 3;
    private static final String[] RENAMABLE_QUALIFIERS = new String[]{"TRK", "BRC", "VW", "SVW"};
    private static final String[] RENAMABLE_SCOPES = new String[]{"PRJ"};
    private static final String[] NOT_RENAMABLE_QUALIFIERS = new String[]{"FIL", "UTS", "CLA"};
    private static final String[] NOT_RENAMABLE_SCOPES = new String[]{"FIL"};
    private final MyBatis mybatis;

    public ResourceIndexerDao(MyBatis mybatis) {
        this.mybatis = mybatis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceIndexerDao indexProject(int rootProjectId) {
        SqlSession session = this.mybatis.openSession(ExecutorType.BATCH);
        try {
            ResourceIndexerMapper mapper = (ResourceIndexerMapper)session.getMapper(ResourceIndexerMapper.class);
            this.doIndexProject(rootProjectId, session, mapper);
            session.commit();
            ResourceIndexerDao resourceIndexerDao = this;
            return resourceIndexerDao;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceIndexerDao indexProjects() {
        final SqlSession session = this.mybatis.openSession(ExecutorType.BATCH);
        try {
            final ResourceIndexerMapper mapper = (ResourceIndexerMapper)session.getMapper(ResourceIndexerMapper.class);
            session.select("selectRootProjectIds", (Object)ResourceIndexerQuery.create(), new ResultHandler(){

                public void handleResult(ResultContext context) {
                    Integer rootProjectId = (Integer)context.getResultObject();
                    ResourceIndexerDao.this.doIndexProject(rootProjectId, session, mapper);
                    session.commit();
                }
            });
            ResourceIndexerDao resourceIndexerDao = this;
            return resourceIndexerDao;
        }
        finally {
            session.close();
        }
    }

    private void doIndexProject(int rootProjectId, SqlSession session, final ResourceIndexerMapper mapper) {
        ResourceIndexerQuery query = ResourceIndexerQuery.create().setNonIndexedOnly(true).setQualifiers(NOT_RENAMABLE_QUALIFIERS).setScopes(NOT_RENAMABLE_SCOPES).setRootProjectId(rootProjectId);
        session.select("selectResources", (Object)query, new ResultHandler(){

            public void handleResult(ResultContext context) {
                ResourceDto resource = (ResourceDto)context.getResultObject();
                ResourceIndexerDao.this.doIndex(resource, mapper);
            }
        });
        query = ResourceIndexerQuery.create().setNonIndexedOnly(false).setQualifiers(RENAMABLE_QUALIFIERS).setScopes(RENAMABLE_SCOPES).setRootProjectId(rootProjectId);
        session.select("selectResources", (Object)query, new ResultHandler(){

            public void handleResult(ResultContext context) {
                ResourceDto resource = (ResourceDto)context.getResultObject();
                mapper.deleteByResourceId(resource.getId());
                ResourceIndexerDao.this.doIndex(resource, mapper);
            }
        });
    }

    void doIndex(ResourceDto resource, ResourceIndexerMapper mapper) {
        String key = ResourceIndexerDao.nameToKey(resource.getName());
        if (key.length() >= 3) {
            ResourceIndexDto dto = new ResourceIndexDto().setResourceId(resource.getId()).setQualifier(resource.getQualifier()).setRootProjectId(resource.getRootId()).setNameSize(resource.getName().length());
            for (int position = 0; position <= key.length() - 3; ++position) {
                dto.setPosition(position);
                dto.setKey(StringUtils.substring((String)key, (int)position));
                mapper.insert(dto);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indexResource(int id, String name, String qualifier, int rootProjectId) {
        boolean indexed = false;
        if (ResourceIndexerDao.isIndexableQualifier(qualifier)) {
            SqlSession session = this.mybatis.openSession();
            try {
                String key = ResourceIndexerDao.nameToKey(name);
                if (key.length() >= 3) {
                    indexed = true;
                    ResourceIndexerMapper mapper = (ResourceIndexerMapper)session.getMapper(ResourceIndexerMapper.class);
                    boolean toBeIndexed = this.sanitizeIndex(id, key, mapper);
                    if (toBeIndexed) {
                        ResourceIndexDto dto = new ResourceIndexDto().setResourceId(id).setQualifier(qualifier).setRootProjectId(rootProjectId).setNameSize(name.length());
                        for (int position = 0; position <= key.length() - 3; ++position) {
                            dto.setPosition(position);
                            dto.setKey(StringUtils.substring((String)key, (int)position));
                            mapper.insert(dto);
                        }
                        session.commit();
                    }
                }
            }
            finally {
                session.close();
            }
        }
        return indexed;
    }

    private boolean sanitizeIndex(int resourceId, String key, ResourceIndexerMapper mapper) {
        ResourceIndexDto masterIndex = mapper.selectMasterIndexByResourceId(resourceId);
        if (masterIndex != null && !StringUtils.equals((String)key, (String)masterIndex.getKey())) {
            mapper.deleteByResourceId(resourceId);
            masterIndex = null;
        }
        return masterIndex == null;
    }

    static String nameToKey(String input) {
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)input));
    }

    static boolean isIndexableQualifier(String qualifier) {
        return ArrayUtils.contains((Object[])RENAMABLE_QUALIFIERS, (Object)qualifier) || ArrayUtils.contains((Object[])NOT_RENAMABLE_QUALIFIERS, (Object)qualifier);
    }
}

