/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.plugins;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.sonar.api.Plugin;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.ZipUtils;
import org.sonar.core.plugins.DefaultPluginMetadata;
import org.sonar.updatecenter.common.PluginKeyUtils;
import org.sonar.updatecenter.common.PluginManifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginFileExtractor {
    public DefaultPluginMetadata installInSameLocation(File pluginFile, boolean isCore, List<File> deprecatedExtensions) {
        return this.install(pluginFile, isCore, deprecatedExtensions, null);
    }

    public DefaultPluginMetadata install(File pluginFile, boolean isCore, List<File> deprecatedExtensions, File toDir) {
        DefaultPluginMetadata metadata = this.extractMetadata(pluginFile, isCore);
        metadata.setDeprecatedExtensions(deprecatedExtensions);
        return this.install(metadata, toDir);
    }

    public DefaultPluginMetadata install(DefaultPluginMetadata metadata, File toDir) {
        try {
            File pluginBasedir;
            File pluginFile = metadata.getFile();
            if (toDir != null) {
                pluginBasedir = toDir;
                FileUtils.forceMkdir((File)pluginBasedir);
                File targetFile = new File(pluginBasedir, pluginFile.getName());
                FileUtils.copyFile((File)pluginFile, (File)targetFile);
                metadata.addDeployedFile(targetFile);
            } else {
                pluginBasedir = pluginFile.getParentFile();
                metadata.addDeployedFile(pluginFile);
            }
            if (metadata.getPathsToInternalDeps().length > 0) {
                ZipUtils.unzip((File)pluginFile, (File)pluginBasedir, (ZipUtils.ZipEntryFilter)new ZipUtils.ZipEntryFilter(){

                    public boolean accept(ZipEntry entry) {
                        return entry.getName().startsWith("META-INF/lib");
                    }
                });
                for (String depPath : metadata.getPathsToInternalDeps()) {
                    File dependency = new File(pluginBasedir, depPath);
                    if (!dependency.isFile() || !dependency.exists()) {
                        throw new IllegalArgumentException("Dependency " + depPath + " can not be found in " + pluginFile.getName());
                    }
                    metadata.addDeployedFile(dependency);
                }
            }
            for (File extension : metadata.getDeprecatedExtensions()) {
                File toFile = new File(pluginBasedir, extension.getName());
                if (!toFile.equals(extension)) {
                    FileUtils.copyFile((File)extension, (File)toFile);
                }
                metadata.addDeployedFile(toFile);
            }
            return metadata;
        }
        catch (IOException e) {
            throw new SonarException("Fail to install plugin: " + metadata, (Throwable)e);
        }
    }

    public DefaultPluginMetadata extractMetadata(File file, boolean isCore) {
        try {
            PluginManifest manifest = new PluginManifest(file);
            DefaultPluginMetadata metadata = DefaultPluginMetadata.create(file);
            metadata.setKey(manifest.getKey());
            metadata.setName(manifest.getName());
            metadata.setDescription(manifest.getDescription());
            metadata.setLicense(manifest.getLicense());
            metadata.setOrganization(manifest.getOrganization());
            metadata.setOrganizationUrl(manifest.getOrganizationUrl());
            metadata.setMainClass(manifest.getMainClass());
            metadata.setVersion(manifest.getVersion());
            metadata.setHomepage(manifest.getHomepage());
            metadata.setPathsToInternalDeps(manifest.getDependencies());
            metadata.setUseChildFirstClassLoader(manifest.isUseChildFirstClassLoader());
            metadata.setBasePlugin(manifest.getBasePlugin());
            metadata.setCore(isCore);
            if (metadata.isOldManifest()) {
                this.completeDeprecatedMetadata(metadata);
            }
            return metadata;
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to extract plugin metadata from file: " + file, e);
        }
    }

    private void completeDeprecatedMetadata(DefaultPluginMetadata metadata) throws IOException {
        String mainClass = metadata.getMainClass();
        File pluginFile = metadata.getFile();
        try {
            File tempFile = File.createTempFile(pluginFile.getName(), null);
            FileUtils.copyFile((File)pluginFile, (File)tempFile);
            URLClassLoader pluginClassLoader = URLClassLoader.newInstance(new URL[]{tempFile.toURI().toURL()}, this.getClass().getClassLoader());
            Plugin pluginInstance = (Plugin)pluginClassLoader.loadClass(mainClass).newInstance();
            metadata.setKey(PluginKeyUtils.sanitize((String)pluginInstance.getKey()));
            metadata.setDescription(pluginInstance.getDescription());
            metadata.setName(pluginInstance.getName());
        }
        catch (Exception e) {
            throw new RuntimeException("The metadata main class can not be created. Plugin file=" + pluginFile.getName() + ", class=" + mainClass, e);
        }
    }
}

