/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.plugins;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugin;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.api.utils.SonarException;
import org.sonar.core.plugins.ResourcesClassloader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginClassloaders {
    private static final String[] PREFIXES_TO_EXPORT = new String[]{"org.sonar.plugins.", "com.sonar.plugins.", "com.sonarsource.plugins."};
    private static final Logger LOG = LoggerFactory.getLogger(PluginClassloaders.class);
    private ClassWorld world = new ClassWorld();
    private ClassLoader baseClassloader;
    private boolean done = false;

    public PluginClassloaders(ClassLoader baseClassloader) {
        this.baseClassloader = baseClassloader;
    }

    public Map<String, Plugin> init(Collection<PluginMetadata> plugins) {
        ArrayList children = Lists.newArrayList();
        for (PluginMetadata plugin : plugins) {
            if (StringUtils.isBlank((String)plugin.getBasePlugin())) {
                this.add(plugin);
                continue;
            }
            children.add(plugin);
        }
        for (PluginMetadata child : children) {
            this.extend(child);
        }
        this.done();
        HashMap pluginsByKey = Maps.newHashMap();
        for (PluginMetadata metadata : plugins) {
            pluginsByKey.put(metadata.getKey(), this.instantiatePlugin(metadata));
        }
        return pluginsByKey;
    }

    public ClassLoader add(PluginMetadata plugin) {
        if (this.done) {
            throw new IllegalStateException("Plugin classloaders are already initialized");
        }
        try {
            ClassRealm realm;
            ArrayList resources = Lists.newArrayList();
            ArrayList others = Lists.newArrayList();
            for (File file : plugin.getDeployedFiles()) {
                if (this.isResource(file)) {
                    resources.add(file.toURI().toURL());
                    continue;
                }
                others.add(file.toURI().toURL());
            }
            ClassLoader parent = resources.isEmpty() ? this.baseClassloader : new ResourcesClassloader(resources, this.baseClassloader);
            if (plugin.isUseChildFirstClassLoader()) {
                ClassRealm parentRealm = this.world.newRealm(plugin.getKey() + "-parent", parent);
                realm = parentRealm.createChildRealm(plugin.getKey());
            } else {
                realm = this.world.newRealm(plugin.getKey(), parent);
            }
            for (URL url : others) {
                realm.addURL(url);
            }
            return realm;
        }
        catch (Exception e) {
            throw new SonarException((Throwable)e);
        }
    }

    public boolean extend(PluginMetadata plugin) {
        if (this.done) {
            throw new IllegalStateException("Plugin classloaders are already initialized");
        }
        try {
            ClassRealm base = this.world.getRealm(plugin.getBasePlugin());
            if (base == null) {
                LOG.warn("Plugin " + plugin.getKey() + " is ignored because base plugin is not installed: " + plugin.getBasePlugin());
                return false;
            }
            base.createChildRealm(plugin.getKey());
            for (File file : plugin.getDeployedFiles()) {
                base.addURL(file.toURI().toURL());
            }
            return true;
        }
        catch (Exception e) {
            throw new SonarException((Throwable)e);
        }
    }

    public void done() {
        if (this.done) {
            throw new IllegalStateException("Plugin classloaders are already initialized");
        }
        for (Object o : this.world.getRealms()) {
            ClassRealm realm = (ClassRealm)o;
            if (StringUtils.endsWith((String)realm.getId(), (String)"-parent")) continue;
            String[] packagesToExport = new String[PREFIXES_TO_EXPORT.length];
            for (int i = 0; i < PREFIXES_TO_EXPORT.length; ++i) {
                packagesToExport[i] = PREFIXES_TO_EXPORT[i] + realm.getId() + ".api";
            }
            this.export(realm, packagesToExport);
        }
        this.done = true;
    }

    private void export(ClassRealm realm, String ... packages) {
        for (Object o : this.world.getRealms()) {
            ClassRealm dep = (ClassRealm)o;
            if (StringUtils.equals((String)dep.getId(), (String)realm.getId())) continue;
            try {
                for (String packageName : packages) {
                    dep.importFrom(realm.getId(), packageName);
                }
            }
            catch (NoSuchRealmException e) {
                throw new SonarException((Throwable)e);
            }
        }
    }

    public ClassLoader get(String key) {
        if (!this.done) {
            throw new IllegalStateException("Plugin classloaders are not initialized");
        }
        try {
            return this.world.getRealm(key);
        }
        catch (NoSuchRealmException e) {
            return null;
        }
    }

    public Plugin instantiatePlugin(PluginMetadata metadata) {
        try {
            Class<?> claz = this.get(metadata.getKey()).loadClass(metadata.getMainClass());
            return (Plugin)claz.newInstance();
        }
        catch (Exception e) {
            throw new SonarException("Fail to load plugin " + metadata.getKey(), (Throwable)e);
        }
    }

    private boolean isResource(File file) {
        return !StringUtils.endsWithIgnoreCase((String)file.getName(), (String)".jar") && !file.isDirectory();
    }

    public void clean() {
        for (ClassRealm realm : this.world.getRealms()) {
            try {
                this.world.disposeRealm(realm.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.world = null;
        }
    }
}

