/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence.dialect;

import org.apache.commons.lang.StringUtils;
import org.hibernate.dialect.SQLServerDialect;
import org.sonar.core.persistence.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsSql
implements Dialect {
    public static final String ID = "mssql";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getActiveRecordDialectCode() {
        return "sqlserver";
    }

    @Override
    public String getActiveRecordJdbcAdapter() {
        return "jdbc";
    }

    @Override
    public Class<? extends org.hibernate.dialect.Dialect> getHibernateDialectClass() {
        return MsSqlDialect.class;
    }

    @Override
    public boolean matchesJdbcURL(String jdbcConnectionURL) {
        return StringUtils.startsWithIgnoreCase((String)jdbcConnectionURL, (String)"jdbc:microsoft:sqlserver:") || StringUtils.startsWithIgnoreCase((String)jdbcConnectionURL, (String)"jdbc:jtds:sqlserver:");
    }

    @Override
    public String getDefaultDriverClassName() {
        return "net.sourceforge.jtds.jdbc.Driver";
    }

    @Override
    public String getConnectionInitStatement(String schema) {
        return null;
    }

    public static class MsSqlDialect
    extends SQLServerDialect {
        public MsSqlDialect() {
            this.registerColumnType(8, "decimal");
            this.registerColumnType(12, 255, "nvarchar($l)");
            this.registerColumnType(12, 0xFFFFFF, "nvarchar(max)");
            this.registerColumnType(1, "nchar(1)");
            this.registerColumnType(2005, "nvarchar(max)");
        }

        public String getTypeName(int code, int length, int precision, int scale) {
            if (code != 2005) {
                return super.getTypeName(code, length, precision, scale);
            }
            return "ntext";
        }
    }
}

