/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence.dialect;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.core.persistence.dialect.Derby;
import org.sonar.core.persistence.dialect.Dialect;
import org.sonar.core.persistence.dialect.MsSql;
import org.sonar.core.persistence.dialect.MySql;
import org.sonar.core.persistence.dialect.Oracle;
import org.sonar.core.persistence.dialect.PostgreSql;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DialectUtils {
    private static final Dialect[] DIALECTS = new Dialect[]{new Derby(), new MySql(), new Oracle(), new PostgreSql(), new MsSql()};

    private DialectUtils() {
    }

    public static Dialect find(String dialectId, String jdbcConnectionUrl) {
        Dialect match;
        Dialect dialect = match = StringUtils.isNotBlank((String)dialectId) ? DialectUtils.findById(dialectId) : DialectUtils.findByJdbcUrl(jdbcConnectionUrl);
        if (match == null) {
            throw new SonarException("Unable to determine database dialect to use within sonar with dialect " + dialectId + " jdbc url " + jdbcConnectionUrl);
        }
        return match;
    }

    private static Dialect findByJdbcUrl(final String jdbcConnectionUrl) {
        Dialect match = DialectUtils.findDialect(new Predicate<Dialect>(){

            public boolean apply(Dialect dialect) {
                return dialect.matchesJdbcURL(StringUtils.trimToEmpty((String)jdbcConnectionUrl));
            }
        });
        return match;
    }

    private static Dialect findById(final String dialectId) {
        return DialectUtils.findDialect(new Predicate<Dialect>(){

            public boolean apply(Dialect dialect) {
                return dialect.getId().equals(dialectId);
            }
        });
    }

    private static Dialect findDialect(Predicate<Dialect> predicate) {
        try {
            return (Dialect)Iterators.find((Iterator)Iterators.forArray((Object[])DIALECTS), predicate);
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }
}

