/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.core.dashboard.ActiveDashboardDto;
import org.sonar.core.dashboard.ActiveDashboardMapper;
import org.sonar.core.dashboard.DashboardDto;
import org.sonar.core.dashboard.DashboardMapper;
import org.sonar.core.dashboard.WidgetDto;
import org.sonar.core.dashboard.WidgetMapper;
import org.sonar.core.dashboard.WidgetPropertyDto;
import org.sonar.core.dashboard.WidgetPropertyMapper;
import org.sonar.core.duplication.DuplicationMapper;
import org.sonar.core.duplication.DuplicationUnitDto;
import org.sonar.core.persistence.Database;
import org.sonar.core.resource.ResourceDto;
import org.sonar.core.resource.ResourceIndexDto;
import org.sonar.core.resource.ResourceIndexerMapper;
import org.sonar.core.review.ReviewDto;
import org.sonar.core.review.ReviewMapper;
import org.sonar.core.rule.RuleDto;
import org.sonar.core.rule.RuleMapper;
import org.sonar.core.template.LoadedTemplateDto;
import org.sonar.core.template.LoadedTemplateMapper;

public class MyBatis
implements BatchComponent,
ServerComponent {
    private Database database;
    private SqlSessionFactory sessionFactory;

    public MyBatis(Database database) {
        this.database = database;
    }

    public MyBatis start() throws IOException {
        Configuration conf = new Configuration();
        conf.setEnvironment(new Environment("production", (TransactionFactory)MyBatis.createTransactionFactory(), this.database.getDataSource()));
        conf.setUseGeneratedKeys(true);
        conf.setLazyLoadingEnabled(false);
        this.loadAlias(conf, "ActiveDashboard", ActiveDashboardDto.class);
        this.loadAlias(conf, "Dashboard", DashboardDto.class);
        this.loadAlias(conf, "DuplicationUnit", DuplicationUnitDto.class);
        this.loadAlias(conf, "LoadedTemplate", LoadedTemplateDto.class);
        this.loadAlias(conf, "Review", ReviewDto.class);
        this.loadAlias(conf, "Resource", ResourceDto.class);
        this.loadAlias(conf, "ResourceIndex", ResourceIndexDto.class);
        this.loadAlias(conf, "Rule", RuleDto.class);
        this.loadAlias(conf, "Widget", WidgetDto.class);
        this.loadAlias(conf, "WidgetProperty", WidgetPropertyDto.class);
        this.loadMapper(conf, ActiveDashboardMapper.class);
        this.loadMapper(conf, DashboardMapper.class);
        this.loadMapper(conf, DuplicationMapper.class);
        this.loadMapper(conf, LoadedTemplateMapper.class);
        this.loadMapper(conf, ReviewMapper.class);
        this.loadMapper(conf, ResourceIndexerMapper.class);
        this.loadMapper(conf, RuleMapper.class);
        this.loadMapper(conf, WidgetMapper.class);
        this.loadMapper(conf, WidgetPropertyMapper.class);
        this.sessionFactory = new SqlSessionFactoryBuilder().build(conf);
        return this;
    }

    public SqlSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public SqlSession openSession() {
        return this.sessionFactory.openSession();
    }

    public SqlSession openSession(ExecutorType type) {
        return this.sessionFactory.openSession(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMapper(Configuration conf, Class mapperClass) throws IOException {
        InputStream input = this.getPathToMapper(mapperClass);
        try {
            XMLMapperBuilder mapperParser = new XMLMapperBuilder(input, conf, mapperClass.getName(), conf.getSqlFragments());
            mapperParser.parse();
            conf.addLoadedResource(mapperClass.getName());
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    private InputStream getPathToMapper(Class mapperClass) {
        InputStream input = this.getClass().getResourceAsStream("/" + StringUtils.replace((String)mapperClass.getName(), (String)".", (String)"/") + "-" + this.database.getDialect().getId() + ".xml");
        if (input == null) {
            input = this.getClass().getResourceAsStream("/" + StringUtils.replace((String)mapperClass.getName(), (String)".", (String)"/") + ".xml");
        }
        return input;
    }

    private void loadAlias(Configuration conf, String alias, Class dtoClass) {
        conf.getTypeAliasRegistry().registerAlias(alias, dtoClass);
    }

    private static JdbcTransactionFactory createTransactionFactory() {
        return new JdbcTransactionFactory();
    }
}

