/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Settings;
import org.sonar.core.persistence.Database;
import org.sonar.core.persistence.dialect.Dialect;
import org.sonar.core.persistence.dialect.DialectUtils;
import org.sonar.jpa.session.CustomHibernateConnectionProvider;

public class DefaultDatabase
implements Database {
    private static final Logger LOG = LoggerFactory.getLogger(Database.class);
    private Settings settings;
    private BasicDataSource datasource;
    private Dialect dialect;
    private Properties properties;

    public DefaultDatabase(Settings settings) {
        this.settings = settings;
    }

    public final DefaultDatabase start() {
        try {
            this.doBeforeStart();
            this.initSettings();
            this.initDatasource();
            return this;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to connect to database", e);
        }
    }

    void initSettings() {
        this.initProperties();
        this.initDialect();
        this.initSchema();
    }

    private void initProperties() {
        this.properties = new Properties();
        DefaultDatabase.completeProperties(this.settings, this.properties, "sonar.jdbc.");
        DefaultDatabase.completeProperties(this.settings, this.properties, "sonar.hibernate.");
        DefaultDatabase.completeDefaultProperties(this.properties);
        this.doCompleteProperties(this.properties);
    }

    private void initDialect() {
        this.dialect = DialectUtils.find(this.properties.getProperty("sonar.jdbc.dialect"), this.properties.getProperty("sonar.jdbc.url"));
        if (this.dialect == null) {
            throw new IllegalStateException("Can not guess the JDBC dialect. Please check the property sonar.jdbc.url.");
        }
        if ("derby".equals(this.dialect.getId())) {
            LoggerFactory.getLogger(DefaultDatabase.class).warn("Derby database should be used for evaluation purpose only");
        }
        if (!this.properties.containsKey("sonar.jdbc.driverClassName")) {
            this.properties.setProperty("sonar.jdbc.driverClassName", this.dialect.getDefaultDriverClassName());
        }
    }

    private void initSchema() {
        String deprecatedSchema = null;
        if ("postgresql".equals(this.dialect.getId())) {
            deprecatedSchema = DefaultDatabase.getSchemaPropertyValue(this.properties, "sonar.jdbc.postgreSearchPath");
        } else if ("oracle".equals(this.dialect.getId())) {
            deprecatedSchema = DefaultDatabase.getSchemaPropertyValue(this.properties, "sonar.hibernate.default_schema");
        }
        if (StringUtils.isNotBlank((String)deprecatedSchema)) {
            this.properties.setProperty("sonar.jdbc.schema", deprecatedSchema);
        }
    }

    private void initDatasource() throws Exception {
        LOG.info("Create JDBC datasource");
        this.datasource = (BasicDataSource)BasicDataSourceFactory.createDataSource((Properties)DefaultDatabase.extractCommonsDbcpProperties(this.properties));
        String initStatement = this.dialect.getConnectionInitStatement(this.getSchema());
        if (StringUtils.isNotBlank((String)initStatement)) {
            this.datasource.setConnectionInitSqls(Arrays.asList(initStatement));
        }
    }

    protected void doBeforeStart() {
    }

    public final DefaultDatabase stop() {
        this.doBeforeStop();
        if (this.datasource != null) {
            try {
                this.datasource.close();
            }
            catch (SQLException e) {
                throw new IllegalStateException("Fail to stop JDBC connection pool", e);
            }
        }
        return this;
    }

    protected void doBeforeStop() {
    }

    public final Dialect getDialect() {
        return this.dialect;
    }

    public final String getSchema() {
        return this.properties.getProperty("sonar.jdbc.schema");
    }

    public Properties getHibernateProperties() {
        Properties props = new Properties();
        List hibernateKeys = this.settings.getKeysStartingWith("sonar.hibernate.");
        for (String hibernateKey : hibernateKeys) {
            props.put(StringUtils.removeStart((String)hibernateKey, (String)"sonar."), this.settings.getString(hibernateKey));
        }
        props.put("hibernate.dialect", this.getDialect().getHibernateDialectClass().getName());
        props.put("hibernate.generate_statistics", (Object)this.settings.getBoolean("sonar.jdbc.hibernate.generate_statistics"));
        props.put("hibernate.hbm2ddl.auto", "validate");
        props.put("hibernate.connection.provider_class", CustomHibernateConnectionProvider.class.getName());
        String schema = this.getSchema();
        if (StringUtils.isNotBlank((String)schema)) {
            props.put("hibernate.default_schema", schema);
        }
        return props;
    }

    public final DataSource getDataSource() {
        return this.datasource;
    }

    public final Properties getProperties() {
        return this.properties;
    }

    protected void doCompleteProperties(Properties properties) {
    }

    static void completeProperties(Settings settings, Properties properties, String prefix) {
        List jdbcKeys = settings.getKeysStartingWith(prefix);
        for (String jdbcKey : jdbcKeys) {
            String value = settings.getString(jdbcKey);
            properties.setProperty(jdbcKey, value);
        }
    }

    static Properties extractCommonsDbcpProperties(Properties properties) {
        Properties result = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!StringUtils.startsWith((String)key, (String)"sonar.jdbc.")) continue;
            result.setProperty(StringUtils.removeStart((String)key, (String)"sonar.jdbc."), (String)entry.getValue());
        }
        result.setProperty("accessToUnderlyingConnectionAllowed", "true");
        return result;
    }

    static String getSchemaPropertyValue(Properties props, String deprecatedKey) {
        String value = props.getProperty("sonar.jdbc.schema");
        if (StringUtils.isBlank((String)value) && deprecatedKey != null) {
            value = props.getProperty(deprecatedKey);
        }
        return StringUtils.isNotBlank((String)value) ? value : null;
    }

    private static void completeDefaultProperties(Properties props) {
        DefaultDatabase.completeDefaultProperty(props, "sonar.jdbc.driverClassName", props.getProperty("sonar.jdbc.driver"));
        DefaultDatabase.completeDefaultProperty(props, "sonar.jdbc.url", "jdbc:derby://localhost:1527/sonar");
        DefaultDatabase.completeDefaultProperty(props, "sonar.jdbc.username", props.getProperty("sonar.jdbc.user", "sonar"));
        DefaultDatabase.completeDefaultProperty(props, "sonar.jdbc.password", "sonar");
        DefaultDatabase.completeDefaultProperty(props, "sonar.jdbc.hibernate.hbm2ddl", "validate");
    }

    private static void completeDefaultProperty(Properties props, String key, String defaultValue) {
        if (props.getProperty(key) == null && defaultValue != null) {
            props.setProperty(key, defaultValue);
        }
    }
}

