/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.i18n;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.sonar.api.ServerComponent;
import org.sonar.core.i18n.I18nManager;

public class GwtI18n
implements ServerComponent {
    public static final String GWT_BUNDLE = "org.sonar.l10n.gwt";
    private I18nManager manager;
    private String[] propertyKeys;

    public GwtI18n(I18nManager manager) {
        this.manager = manager;
    }

    public void start() {
        this.doStart(this.getBundle(Locale.ENGLISH));
    }

    void doStart(ResourceBundle englishBundle) {
        ArrayList keys = Lists.newArrayList();
        Enumeration<String> enumeration = englishBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String propertyKey = enumeration.nextElement();
            keys.add(propertyKey);
        }
        this.propertyKeys = keys.toArray(new String[keys.size()]);
    }

    String[] getPropertyKeys() {
        return this.propertyKeys;
    }

    public String getJsDictionnary(Locale locale) {
        ResourceBundle bundle = this.getBundle(locale);
        return this.getJsDictionnary(bundle);
    }

    String getJsDictionnary(ResourceBundle bundle) {
        StringBuilder js = new StringBuilder("var l10n = {");
        for (int index = 0; index < this.propertyKeys.length; ++index) {
            String key = this.propertyKeys[index];
            String value = StringEscapeUtils.escapeJavaScript((String)bundle.getString(key));
            if (index > 0) {
                js.append(",");
            }
            js.append("\"").append(key).append("\": \"").append(value).append("\"");
        }
        js.append("};");
        return js.toString();
    }

    ResourceBundle getBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle(GWT_BUNDLE, locale, this.manager.getLanguagePackClassLoader());
        }
        catch (MissingResourceException e) {
            throw new IllegalStateException("The English bundle for GWT extensions is not deployed", e);
        }
    }
}

