/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.dashboard;

import org.apache.ibatis.session.SqlSession;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.core.dashboard.DashboardDto;
import org.sonar.core.dashboard.DashboardMapper;
import org.sonar.core.dashboard.WidgetDto;
import org.sonar.core.dashboard.WidgetMapper;
import org.sonar.core.dashboard.WidgetPropertyDto;
import org.sonar.core.dashboard.WidgetPropertyMapper;
import org.sonar.core.persistence.MyBatis;

public class DashboardDao
implements BatchComponent,
ServerComponent {
    private MyBatis mybatis;

    public DashboardDao(MyBatis mybatis) {
        this.mybatis = mybatis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DashboardDto selectGlobalDashboard(String name) {
        SqlSession sqlSession = this.mybatis.openSession();
        try {
            DashboardMapper mapper = (DashboardMapper)sqlSession.getMapper(DashboardMapper.class);
            DashboardDto dashboardDto = mapper.selectGlobalDashboard(name);
            return dashboardDto;
        }
        finally {
            sqlSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(DashboardDto dashboardDto) {
        SqlSession session = this.mybatis.openSession();
        DashboardMapper dashboardMapper = (DashboardMapper)session.getMapper(DashboardMapper.class);
        WidgetMapper widgetMapper = (WidgetMapper)session.getMapper(WidgetMapper.class);
        WidgetPropertyMapper widgetPropertyMapper = (WidgetPropertyMapper)session.getMapper(WidgetPropertyMapper.class);
        try {
            dashboardMapper.insert(dashboardDto);
            for (WidgetDto widgetDto : dashboardDto.getWidgets()) {
                widgetDto.setDashboardId(dashboardDto.getId());
                widgetMapper.insert(widgetDto);
                for (WidgetPropertyDto widgetPropertyDto : widgetDto.getWidgetProperties()) {
                    widgetPropertyDto.setWidgetId(widgetDto.getId());
                    widgetPropertyMapper.insert(widgetPropertyDto);
                }
            }
            session.commit();
        }
        finally {
            session.close();
        }
    }
}

