/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.config;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;

public final class Logback {
    private Logback() {
    }

    public static void configure(String classloaderPath) {
        InputStream input = Logback.class.getResourceAsStream(classloaderPath);
        if (input == null) {
            throw new IllegalArgumentException("Logback configuration not found in classloader: " + classloaderPath);
        }
        Logback.configure(input);
    }

    public static void configure(File logbackFile) {
        try {
            FileInputStream input = FileUtils.openInputStream((File)logbackFile);
            Logback.configure(input);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Fail to load the Logback configuration: " + logbackFile, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configure(InputStream input) {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)lc);
            lc.reset();
            configurator.doConfigure(input);
        }
        catch (JoranException joranException) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)lc);
    }
}

