/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.configuration.Property;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.jpa.session.DatabaseSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static void copyProperties(Properties from, Map<String, String> to) {
        for (Map.Entry<Object, Object> entry : from.entrySet()) {
            String key = (String)entry.getKey();
            to.put(key, entry.getValue().toString());
        }
    }

    public static Properties openProperties(File file) throws IOException {
        FileInputStream input = FileUtils.openInputStream((File)file);
        return ConfigurationUtils.readInputStream(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readInputStream(InputStream input) throws IOException {
        try {
            Properties p = new Properties();
            p.load(input);
            Properties properties = p;
            return properties;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public static Properties interpolateEnvVariables(Properties properties) {
        return ConfigurationUtils.interpolateVariables(properties, System.getenv());
    }

    public static Properties interpolateVariables(Properties properties, Map<String, String> variables) {
        Properties result = new Properties();
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)properties.get(key);
            String interpolatedValue = StrSubstitutor.replace((Object)value, variables, (String)"${env:", (String)"}");
            result.setProperty(key, interpolatedValue);
        }
        return result;
    }

    public static List<Property> getProjectProperties(DatabaseSessionFactory dbFactory, String moduleKey) {
        DatabaseSession session = ConfigurationUtils.prepareDbSession(dbFactory);
        ResourceModel resource = (ResourceModel)session.getSingleResult(ResourceModel.class, new Object[]{"key", moduleKey});
        if (resource != null) {
            return session.createQuery("from " + Property.class.getSimpleName() + " p where p.resourceId=:resourceId and p.userId is null").setParameter("resourceId", (Object)resource.getId()).getResultList();
        }
        return Collections.emptyList();
    }

    public static List<Property> getGeneralProperties(DatabaseSessionFactory dbFactory) {
        DatabaseSession session = ConfigurationUtils.prepareDbSession(dbFactory);
        return session.createQuery("from " + Property.class.getSimpleName() + " p where p.resourceId is null and p.userId is null").getResultList();
    }

    private static DatabaseSession prepareDbSession(DatabaseSessionFactory dbFactory) {
        DatabaseSession session = dbFactory.getSession();
        session.commit();
        return session;
    }

    public static void copyToCommonsConfiguration(Map<String, String> input, Configuration commonsConfig) {
        commonsConfig.clear();
        for (Map.Entry<String, String> entry : input.entrySet()) {
            String key = entry.getKey();
            commonsConfig.setProperty(key, (Object)entry.getValue());
        }
    }
}

