/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.dialect;

import org.apache.commons.lang.StringUtils;
import org.hibernate.dialect.Oracle10gDialect;
import org.sonar.jpa.dialect.Dialect;
import org.sonar.jpa.dialect.OracleSequenceGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Oracle
implements Dialect {
    @Override
    public String getId() {
        return "oracle";
    }

    @Override
    public String getActiveRecordDialectCode() {
        return "oracle";
    }

    @Override
    public String getActiveRecordJdbcAdapter() {
        return "oracle_enhanced";
    }

    @Override
    public Class<? extends org.hibernate.dialect.Dialect> getHibernateDialectClass() {
        return Oracle10gWithDecimalDialect.class;
    }

    @Override
    public boolean matchesJdbcURL(String jdbcConnectionURL) {
        return StringUtils.startsWithIgnoreCase((String)jdbcConnectionURL, (String)"jdbc:oracle:");
    }

    public static class Oracle10gWithDecimalDialect
    extends Oracle10gDialect {
        public Oracle10gWithDecimalDialect() {
            this.registerColumnType(8, "number($p,$s)");
            this.registerColumnType(12, 0xFFFFFF, "clob");
            this.registerColumnType(-3, "blob");
        }

        public Class getNativeIdentifierGeneratorClass() {
            return OracleSequenceGenerator.class;
        }
    }
}

