/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.dialect;

import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.dialect.SQLServerDialect;
import org.sonar.jpa.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsSql
implements Dialect {
    @Override
    public String getId() {
        return "mssql";
    }

    @Override
    public String getActiveRecordDialectCode() {
        return "sqlserver";
    }

    @Override
    public String getActiveRecordJdbcAdapter() {
        return "jdbc";
    }

    @Override
    public Class<? extends org.hibernate.dialect.Dialect> getHibernateDialectClass() {
        return MsSqlDialect.class;
    }

    @Override
    public boolean matchesJdbcURL(String jdbcConnectionURL) {
        return StringUtils.startsWithIgnoreCase((String)jdbcConnectionURL, (String)"jdbc:microsoft:sqlserver:") || StringUtils.startsWithIgnoreCase((String)jdbcConnectionURL, (String)"jdbc:jtds:sqlserver:");
    }

    public static class MsSqlDialect
    extends SQLServerDialect {
        public MsSqlDialect() {
            this.registerColumnType(8, "decimal");
            this.registerColumnType(12, 255, "nvarchar($l)");
            this.registerColumnType(12, 0xFFFFFF, "nvarchar(max)");
            this.registerColumnType(1, "nchar(1)");
            this.registerColumnType(2005, "nvarchar(max)");
        }

        public String getTypeName(int code, int length, int precision, int scale) throws HibernateException {
            if (code != 2005) {
                return super.getTypeName(code, length, precision, scale);
            }
            return "ntext";
        }
    }
}

