/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.measures.Metric;
import org.sonar.jpa.dao.BaseDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasuresDao
extends BaseDao {
    private final Map<String, Metric> metricsByName = new HashMap<String, Metric>();

    public MeasuresDao(DatabaseSession session) {
        super(session);
    }

    public Metric getMetric(Metric metric) {
        return this.getMetricsByName().get(metric.getKey());
    }

    public List<Metric> getMetrics(List<Metric> metrics) {
        ArrayList<Metric> result = new ArrayList<Metric>();
        for (Metric metric : metrics) {
            result.add(this.getMetric(metric));
        }
        return result;
    }

    public Metric getMetric(String metricName) {
        return this.getMetricsByName().get(metricName);
    }

    public Collection<Metric> getMetrics() {
        return this.getMetricsByName().values();
    }

    public Collection<Metric> getEnabledMetrics() {
        return CollectionUtils.select(this.getMetricsByName().values(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return ((Metric)o).getEnabled();
            }
        });
    }

    public Collection<Metric> getUserDefinedMetrics() {
        return CollectionUtils.select(this.getMetricsByName().values(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                Metric m = (Metric)o;
                return m.getEnabled() != false && m.getOrigin() != Metric.Origin.JAV;
            }
        });
    }

    public void disableAutomaticMetrics() {
        this.getSession().createQuery("update " + Metric.class.getSimpleName() + " m set m.enabled=false where m.userManaged=false").executeUpdate();
        this.getSession().commit();
        this.metricsByName.clear();
    }

    public void registerMetrics(Collection<Metric> metrics) {
        if (metrics != null) {
            for (Metric metric : metrics) {
                metric.setEnabled(Boolean.TRUE);
                this.persistMetric(metric);
            }
            this.getSession().commit();
        }
    }

    public void persistMetric(Metric metric) {
        Metric dbMetric = this.getMetric(metric);
        if (dbMetric != null) {
            dbMetric.merge(metric);
            this.getSession().getEntityManager().merge((Object)dbMetric);
        } else {
            this.getSession().getEntityManager().persist((Object)metric);
        }
        this.metricsByName.clear();
    }

    public void disabledMetrics(Collection<Metric> metrics) {
        for (Metric metric : metrics) {
            metric.setEnabled(Boolean.FALSE);
            this.getSession().getEntityManager().persist((Object)metric);
            this.metricsByName.put(metric.getName(), metric);
        }
    }

    private Map<String, Metric> getMetricsByName() {
        if (this.metricsByName.isEmpty()) {
            List metrics = this.getSession().getResults(Metric.class);
            for (Metric metric : metrics) {
                this.metricsByName.put(metric.getKey(), metric);
            }
        }
        return this.metricsByName;
    }
}

