/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.notifications;

import java.util.Date;
import java.util.List;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.configuration.Property;
import org.sonar.api.database.model.User;
import org.sonar.api.notifications.Notification;
import org.sonar.api.notifications.NotificationManager;
import org.sonar.jpa.entity.NotificationQueueElement;
import org.sonar.jpa.session.DatabaseSessionFactory;

public class DefaultNotificationManager
implements NotificationManager {
    private DatabaseSessionFactory sessionFactory;

    public DefaultNotificationManager(DatabaseSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void scheduleForSending(Notification notification) {
        NotificationQueueElement notificationQueueElement = new NotificationQueueElement();
        notificationQueueElement.setCreatedAt(new Date());
        notificationQueueElement.setNotification(notification);
        DatabaseSession session = this.sessionFactory.getSession();
        session.save((Object)notificationQueueElement);
        session.commit();
    }

    public NotificationQueueElement getFromQueue() {
        String hql;
        DatabaseSession session = this.sessionFactory.getSession();
        List notifications = session.createQuery(hql = "FROM " + NotificationQueueElement.class.getSimpleName() + " ORDER BY createdAt ASC").setMaxResults(1).getResultList();
        if (notifications.isEmpty()) {
            this.sessionFactory.clear();
            return null;
        }
        NotificationQueueElement notification = (NotificationQueueElement)notifications.get(0);
        session.removeWithoutFlush((Object)notification);
        session.commit();
        return notification;
    }

    public boolean isEnabled(String username, String channelKey, String dispatcherKey) {
        DatabaseSession session = this.sessionFactory.getSession();
        User user = (User)session.getSingleResult(User.class, new Object[]{"login", username});
        String notificationKey = "notification." + dispatcherKey + "." + channelKey;
        Property property = (Property)((Object)session.getSingleResult(Property.class, new Object[]{"userId", user.getId(), "key", notificationKey}));
        return property != null && "true".equals(property.getValue());
    }
}

