/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.i18n;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.ServerExtension;
import org.sonar.api.i18n.I18n;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.api.platform.PluginRepository;
import org.sonar.api.utils.SonarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18nManager
implements I18n,
ServerExtension {
    private static final Logger LOG = LoggerFactory.getLogger(I18nManager.class);
    public static final String ENGLISH_PACK_PLUGIN_KEY = "l10nen";
    public static final String BUNDLE_PACKAGE = "org.sonar.l10n.";
    private PluginRepository pluginRepository;
    private Map<String, ClassLoader> bundleToClassloaders;
    private Map<String, String> propertyToBundles;
    private ClassLoader languagePackClassLoader;
    private Map<String, Map<Locale, String>> fileContentCache = Maps.newHashMap();

    public I18nManager(PluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    I18nManager(Map<String, ClassLoader> bundleToClassloaders) {
        this.bundleToClassloaders = bundleToClassloaders;
    }

    public void start() {
        this.initClassloaders();
        this.initProperties();
    }

    private void initClassloaders() {
        if (this.bundleToClassloaders == null) {
            this.languagePackClassLoader = this.pluginRepository.getPlugin(ENGLISH_PACK_PLUGIN_KEY).getClass().getClassLoader();
            this.bundleToClassloaders = Maps.newHashMap();
            for (PluginMetadata metadata : this.pluginRepository.getMetadata()) {
                if (!metadata.isCore() && !ENGLISH_PACK_PLUGIN_KEY.equals(metadata.getBasePlugin())) {
                    ClassLoader classLoader = this.pluginRepository.getPlugin(metadata.getKey()).getClass().getClassLoader();
                    this.bundleToClassloaders.put(BUNDLE_PACKAGE + metadata.getKey(), classLoader);
                    continue;
                }
                if (!metadata.isCore()) continue;
                this.bundleToClassloaders.put(BUNDLE_PACKAGE + metadata.getKey(), this.languagePackClassLoader);
            }
        }
        this.bundleToClassloaders = Collections.unmodifiableMap(this.bundleToClassloaders);
    }

    private void initProperties() {
        this.propertyToBundles = Maps.newHashMap();
        for (Map.Entry<String, ClassLoader> entry : this.bundleToClassloaders.entrySet()) {
            try {
                String bundleKey = entry.getKey();
                ResourceBundle bundle = ResourceBundle.getBundle(bundleKey, Locale.ENGLISH, entry.getValue());
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    this.propertyToBundles.put(key, bundleKey);
                }
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        this.propertyToBundles = Collections.unmodifiableMap(this.propertyToBundles);
        LOG.debug(String.format("Loaded %d properties from English bundles", this.propertyToBundles.size()));
    }

    public String message(Locale locale, String key, String defaultValue, Object ... parameters) {
        String bundleKey = this.propertyToBundles.get(key);
        ResourceBundle resourceBundle = this.getBundle(bundleKey, locale);
        return this.message(resourceBundle, key, defaultValue, parameters);
    }

    String messageFromFile(Locale locale, String filename, String relatedProperty, boolean keepInCache) {
        HashMap fileCache = this.fileContentCache.get(filename);
        if (fileCache != null && fileCache.containsKey(locale)) {
            return fileCache.get(locale);
        }
        ClassLoader classloader = this.getClassLoaderForProperty(relatedProperty);
        String result = null;
        if (classloader != null) {
            InputStream input;
            String bundleBase = this.propertyToBundles.get(relatedProperty);
            String filePath = bundleBase.replace('.', '/');
            if (!"en".equals(locale.getLanguage())) {
                filePath = filePath + "_" + locale.getLanguage();
            }
            if ((input = classloader.getResourceAsStream(filePath = filePath + "/" + filename)) != null) {
                try {
                    result = IOUtils.toString((InputStream)input, (String)"UTF-8");
                }
                catch (IOException e) {
                    throw new SonarException("Fail to load file: " + filePath, (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)input);
                }
            }
            if (keepInCache) {
                if (fileCache == null) {
                    fileCache = Maps.newHashMap();
                    this.fileContentCache.put(filename, fileCache);
                }
                fileCache.put(locale, result);
            }
        }
        return result;
    }

    Set<String> getPropertyKeys() {
        return this.propertyToBundles.keySet();
    }

    ResourceBundle getBundle(String bundleKey, Locale locale) {
        try {
            ClassLoader classloader = this.bundleToClassloaders.get(bundleKey);
            if (classloader != null) {
                return ResourceBundle.getBundle(bundleKey, locale, classloader);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    ClassLoader getClassLoaderForProperty(String propertyKey) {
        String bundleKey = this.propertyToBundles.get(propertyKey);
        return bundleKey != null ? this.bundleToClassloaders.get(bundleKey) : null;
    }

    String message(ResourceBundle resourceBundle, String key, String defaultValue, Object ... parameters) {
        String value = null;
        if (resourceBundle != null) {
            try {
                value = resourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (value == null) {
            value = defaultValue;
        }
        if (value != null && parameters.length > 0) {
            return MessageFormat.format(value, parameters);
        }
        return value;
    }

    String extractBundleFromKey(String key) {
        String bundleKey = BUNDLE_PACKAGE + StringUtils.substringBefore((String)key, (String)".");
        if (this.bundleToClassloaders.containsKey(bundleKey)) {
            return bundleKey;
        }
        return "org.sonar.l10n.core";
    }

    ClassLoader getLanguagePackClassLoader() {
        return this.languagePackClassLoader;
    }

    Map<String, Map<Locale, String>> getFileContentCache() {
        return this.fileContentCache;
    }
}

