/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.components;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RuleQuery;
import org.sonar.jpa.session.DatabaseSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRuleFinder
implements RuleFinder {
    private DatabaseSessionFactory sessionFactory;

    public DefaultRuleFinder(DatabaseSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Rule findById(int ruleId) {
        return this.doFindById(ruleId);
    }

    protected final Rule doFindById(int ruleId) {
        return (Rule)this.sessionFactory.getSession().getSingleResult(Rule.class, new Object[]{"id", ruleId, "enabled", true});
    }

    public Rule findByKey(String repositoryKey, String key) {
        return this.doFindByKey(repositoryKey, key);
    }

    protected final Rule doFindByKey(String repositoryKey, String key) {
        return (Rule)this.sessionFactory.getSession().getSingleResult(Rule.class, new Object[]{"pluginName", repositoryKey, "key", key, "enabled", true});
    }

    public final Rule find(RuleQuery query) {
        DatabaseSession session = this.sessionFactory.getSession();
        return (Rule)session.getSingleResult(this.createHqlQuery(session, query), null);
    }

    public final Collection<Rule> findAll(RuleQuery query) {
        DatabaseSession session = this.sessionFactory.getSession();
        return this.createHqlQuery(session, query).getResultList();
    }

    private Query createHqlQuery(DatabaseSession session, RuleQuery query) {
        StringBuilder hql = new StringBuilder().append("from ").append(Rule.class.getSimpleName()).append(" where enabled=true ");
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)query.getRepositoryKey())) {
            hql.append("AND pluginName=:repositoryKey ");
            params.put("repositoryKey", query.getRepositoryKey());
        }
        if (StringUtils.isNotBlank((String)query.getKey())) {
            hql.append("AND key=:key ");
            params.put("key", query.getKey());
        }
        if (StringUtils.isNotBlank((String)query.getConfigKey())) {
            hql.append("AND configKey=:configKey ");
            params.put("configKey", query.getConfigKey());
        }
        Query hqlQuery = session.createQuery(hql.toString());
        for (Map.Entry entry : params.entrySet()) {
            hqlQuery.setParameter((String)entry.getKey(), entry.getValue());
        }
        return hqlQuery;
    }
}

