/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.components;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleQuery;
import org.sonar.core.components.DefaultRuleFinder;
import org.sonar.jpa.session.DatabaseSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CacheRuleFinder
extends DefaultRuleFinder {
    private BiMap<Integer, Rule> rulesById = HashBiMap.create();
    private Map<String, Map<String, Rule>> rulesByKey = Maps.newHashMap();

    public CacheRuleFinder(DatabaseSessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public Rule findById(int ruleId) {
        Rule rule = (Rule)this.rulesById.get((Object)ruleId);
        if (rule == null && (rule = this.doFindById(ruleId)) != null) {
            this.loadRepository(rule.getRepositoryKey());
        }
        return rule;
    }

    @Override
    public Rule findByKey(String repositoryKey, String ruleKey) {
        Map<String, Rule> repository = this.loadRepository(repositoryKey);
        return repository.get(ruleKey);
    }

    private Map<String, Rule> loadRepository(String repositoryKey) {
        HashMap repository = this.rulesByKey.get(repositoryKey);
        if (repository == null) {
            repository = Maps.newHashMap();
            this.rulesByKey.put(repositoryKey, repository);
            for (Rule rule : this.findAll(RuleQuery.create().withRepositoryKey(repositoryKey))) {
                repository.put(rule.getKey(), rule);
                this.rulesById.put((Object)rule.getId(), (Object)rule);
            }
        }
        return repository;
    }
}

