/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.database.configuration;

import java.util.List;
import org.apache.commons.configuration.BaseConfiguration;
import org.sonar.api.database.configuration.Property;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.jpa.session.DatabaseSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDatabaseConfiguration
extends BaseConfiguration {
    private final DatabaseSessionFactory sessionFactory;
    private Integer resourceId = null;

    public ResourceDatabaseConfiguration(DatabaseSessionFactory sessionFactory, ResourceModel resource) {
        this.sessionFactory = sessionFactory;
        if (resource != null) {
            this.resourceId = resource.getId();
        }
        this.load();
    }

    public ResourceDatabaseConfiguration(DatabaseSessionFactory sessionFactory, Integer resourceId) {
        this.sessionFactory = sessionFactory;
        this.resourceId = resourceId;
        this.load();
    }

    public ResourceDatabaseConfiguration(DatabaseSessionFactory sessionFactory, String resourceKey) {
        this.sessionFactory = sessionFactory;
        ResourceModel resource = (ResourceModel)sessionFactory.getSession().getSingleResult(ResourceModel.class, new Object[]{"key", resourceKey});
        if (resource != null) {
            this.resourceId = resource.getId();
        }
        this.load();
    }

    public void load() {
        this.clear();
        this.loadResourceProperties();
    }

    private void loadResourceProperties() {
        if (this.resourceId != null) {
            List properties = this.sessionFactory.getSession().createQuery("from " + Property.class.getSimpleName() + " p where p.resourceId=:resourceId and p.userId is null").setParameter("resourceId", (Object)this.resourceId).getResultList();
            this.registerProperties(properties);
        }
    }

    private void registerProperties(List<Property> properties) {
        if (properties != null) {
            for (Property property : properties) {
                this.setProperty(property.getKey(), property.getValue());
            }
        }
    }
}

