/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.channel;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegexChannel<OUTPUT>
extends Channel<OUTPUT> {
    private final StringBuilder tmpBuilder = new StringBuilder();
    private final Matcher matcher;
    private final String regex;

    public RegexChannel(String regex) {
        this.matcher = Pattern.compile(regex).matcher("");
        this.regex = regex;
    }

    @Override
    public final boolean consume(CodeReader code, OUTPUT output) {
        try {
            if (code.popTo(this.matcher, (Appendable)this.tmpBuilder) > 0) {
                this.consume(this.tmpBuilder, output);
                this.tmpBuilder.delete(0, this.tmpBuilder.length());
                return true;
            }
            return false;
        }
        catch (StackOverflowError e) {
            throw new IllegalArgumentException("The regular expression " + this.regex + " has led to a stack overflow error. " + "This error is certainly due to an inefficient use of alternations. See http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5050507", e);
        }
    }

    protected abstract void consume(CharSequence var1, OUTPUT var2);
}

