/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.sonar.api.batch.CoverageExtension;
import org.sonar.api.batch.Initializer;
import org.sonar.api.batch.SupportedEnvironment;
import org.sonar.api.resources.Project;
import org.sonar.plugins.jacoco.JaCoCoUtils;
import org.sonar.plugins.jacoco.JacocoConfiguration;

@SupportedEnvironment(value={"ant"})
public class JacocoAntInitializer
extends Initializer
implements CoverageExtension {
    private final TaskEnhancer[] taskEnhancers = new TaskEnhancer[]{new JavaLikeTaskEnhancer("java"), new JavaLikeTaskEnhancer("junit"), new TestngTaskEnhancer()};
    private org.apache.tools.ant.Project antProject;
    private JacocoConfiguration configuration;

    public JacocoAntInitializer(org.apache.tools.ant.Project antProject, JacocoConfiguration configuration) {
        this.antProject = antProject;
        this.configuration = configuration;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return project.getAnalysisType().equals((Object)Project.AnalysisType.DYNAMIC);
    }

    public void execute(Project project) {
        String[] names;
        Hashtable hastable = this.antProject.getTargets();
        String jvmArg = this.configuration.getJvmArgument();
        for (String name : names = this.configuration.getAntTargets()) {
            Target target = (Target)hastable.get(name);
            if (target == null) {
                JaCoCoUtils.LOG.warn("Target '{}' not found", (Object)name);
                continue;
            }
            for (Task task : target.getTasks()) {
                for (TaskEnhancer enhancer : this.taskEnhancers) {
                    if (!enhancer.supportsTask(task)) continue;
                    enhancer.enhanceTask(task, jvmArg);
                }
            }
            target.performTasks();
        }
    }

    private static abstract class TaskEnhancer {
        private TaskEnhancer() {
        }

        public abstract boolean supportsTask(Task var1);

        public void enhanceTask(Task task, String jvmArg) {
            this.addJvmArg((UnknownElement)task, jvmArg);
        }

        public void addJvmArg(UnknownElement task, String jvmArg) {
            UnknownElement el = new UnknownElement("jvmarg");
            el.setTaskName("jvmarg");
            el.setQName("jvmarg");
            RuntimeConfigurable runtimeConfigurableWrapper = el.getRuntimeConfigurableWrapper();
            runtimeConfigurableWrapper.setAttribute("value", jvmArg);
            task.getRuntimeConfigurableWrapper().addChild(runtimeConfigurableWrapper);
            task.addChild(el);
        }
    }

    private static class JavaLikeTaskEnhancer
    extends TaskEnhancer {
        private String taskName;

        public JavaLikeTaskEnhancer(String taskName) {
            this.taskName = taskName;
        }

        public boolean supportsTask(Task task) {
            return this.taskName.equals(task.getTaskName());
        }

        public void enhanceTask(Task task, String jvmArg) {
            RuntimeConfigurable configurableWrapper = task.getRuntimeConfigurableWrapper();
            String forkValue = (String)configurableWrapper.getAttributeMap().get("fork");
            if (forkValue == null || !org.apache.tools.ant.Project.toBoolean((String)forkValue)) {
                throw new BuildException("Coverage can only be applied on a forked VM");
            }
            super.enhanceTask(task, jvmArg);
        }
    }

    private static class TestngTaskEnhancer
    extends TaskEnhancer {
        private TestngTaskEnhancer() {
        }

        public boolean supportsTask(Task task) {
            return "testng".equals(task.getTaskName());
        }
    }
}

