/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.maven.MavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.jacoco.JaCoCoUtils;
import org.sonar.plugins.jacoco.JacocoConfiguration;

public class JaCoCoMavenPluginHandler
implements MavenPluginHandler {
    private static final String ARG_LINE_PARAMETER = "argLine";
    private static final String TEST_FAILURE_IGNORE_PARAMETER = "testFailureIgnore";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private JacocoConfiguration configuration;

    public JaCoCoMavenPluginHandler(JacocoConfiguration configuration) {
        this.configuration = configuration;
        this.groupId = "org.apache.maven.plugins";
        this.artifactId = "maven-surefire-plugin";
        this.version = "2.4.3";
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isFixedVersion() {
        return false;
    }

    public String[] getGoals() {
        return new String[]{"test"};
    }

    public void configure(Project project, MavenPlugin plugin) {
        String destfilePath = this.configuration.getReportPath();
        File destfile = project.getFileSystem().resolvePath(destfilePath);
        if (destfile.exists() && destfile.isFile()) {
            JaCoCoUtils.LOG.info("Deleting {}", (Object)destfile);
            if (!destfile.delete()) {
                throw new SonarException("Unable to delete " + destfile);
            }
        }
        String argument = this.configuration.getJvmArgument();
        String argLine = plugin.getParameter(ARG_LINE_PARAMETER);
        argLine = StringUtils.isBlank((String)argLine) ? argument : argument + " " + argLine;
        JaCoCoUtils.LOG.info("JVM options: {}", (Object)argLine);
        plugin.setParameter(ARG_LINE_PARAMETER, argLine);
        plugin.setParameter(TEST_FAILURE_IGNORE_PARAMETER, "true");
    }
}

