/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.jacoco.AbstractAnalyzer;
import org.sonar.plugins.jacoco.JacocoConfiguration;

public class JaCoCoItSensor
implements Sensor {
    private JacocoConfiguration configuration;

    public JaCoCoItSensor(JacocoConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return StringUtils.isNotBlank((String)this.configuration.getItReportPath()) && project.getAnalysisType().isDynamic(true);
    }

    public void analyse(Project project, SensorContext context) {
        new ITAnalyzer().analyse(project, context);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ITAnalyzer
    extends AbstractAnalyzer {
        ITAnalyzer() {
        }

        @Override
        protected String getReportPath(Project project) {
            return JaCoCoItSensor.this.configuration.getItReportPath();
        }

        @Override
        protected void saveMeasures(SensorContext context, JavaFile resource, Collection<Measure> measures) {
            for (Measure measure : measures) {
                Measure itMeasure = this.convertForIT(measure);
                if (itMeasure == null) continue;
                context.saveMeasure((Resource)resource, itMeasure);
            }
        }

        private Measure convertForIT(Measure measure) {
            Measure itMeasure = null;
            if (CoreMetrics.LINES_TO_COVER.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_LINES_TO_COVER, measure.getValue());
            } else if (CoreMetrics.UNCOVERED_LINES.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_UNCOVERED_LINES, measure.getValue());
            } else if (CoreMetrics.COVERAGE_LINE_HITS_DATA.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_COVERAGE_LINE_HITS_DATA, measure.getData());
            } else if (CoreMetrics.CONDITIONS_TO_COVER.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_CONDITIONS_TO_COVER, measure.getValue());
            } else if (CoreMetrics.UNCOVERED_CONDITIONS.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_UNCOVERED_CONDITIONS, measure.getValue());
            } else if (CoreMetrics.COVERED_CONDITIONS_BY_LINE.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_COVERED_CONDITIONS_BY_LINE, measure.getData());
            } else if (CoreMetrics.CONDITIONS_BY_LINE.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_CONDITIONS_BY_LINE, measure.getData());
            }
            return itMeasure;
        }
    }
}

