/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco.itcoverage.viewer.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.gwt.ui.SourcePanel;
import org.sonar.wsclient.gwt.AbstractCallback;
import org.sonar.wsclient.gwt.Callback;
import org.sonar.wsclient.gwt.Sonar;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.ResourceQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoveragePanel
extends SourcePanel {
    private Map<Integer, String> hitsByLine = new HashMap<Integer, String>();
    private Map<Integer, String> branchHitsByLine = new HashMap<Integer, String>();

    public CoveragePanel(Resource resource) {
        super(resource);
        this.loadCoverageHits(resource);
    }

    private void loadCoverageHits(Resource resource) {
        ResourceQuery query = ResourceQuery.createForResource((Resource)resource, (String[])new String[]{"it_coverage_line_hits_data", "it_branch_coverage_hits_data"});
        Sonar.getInstance().find((Query)query, (Callback)new AbstractCallback<Resource>(){

            protected void doOnResponse(Resource resource) {
                CoveragePanel.this.handleResponse(resource, "it_coverage_line_hits_data", CoveragePanel.this.hitsByLine);
                CoveragePanel.this.handleResponse(resource, "it_branch_coverage_hits_data", CoveragePanel.this.branchHitsByLine);
                CoveragePanel.this.setStarted();
            }
        });
    }

    private void handleResponse(Resource resource, String metric, Map<Integer, String> values) {
        if (resource == null || resource.getMeasure(metric) == null) {
            return;
        }
        values.clear();
        String linesValue = resource.getMeasure(metric).getData();
        String[] lineWithValueArray = linesValue.contains(",") ? linesValue.split(",") : linesValue.split(";");
        for (String lineWithValue : lineWithValueArray) {
            String[] elt = lineWithValue.split("=");
            if (elt == null || elt.length != 2) continue;
            values.put(Integer.parseInt(elt[0]), elt[1]);
        }
    }

    protected boolean shouldDecorateLine(int index) {
        return index > 0;
    }

    protected List<SourcePanel.Row> decorateLine(int index, String source) {
        SourcePanel.Row row = new SourcePanel.Row().setLineIndex(index, "");
        String hits = this.hitsByLine.get(index);
        String branchHits = this.branchHitsByLine.get(index);
        boolean hasLineCoverage = null != hits;
        boolean hasBranchCoverage = null != branchHits;
        boolean lineIsCovered = hasLineCoverage && Integer.parseInt(hits) > 0;
        boolean branchIsCovered = hasBranchCoverage && "100%".equals(branchHits);
        row.setSource(source, "");
        row.setValue("&nbsp;", "");
        row.setValue2("&nbsp;", "");
        if (lineIsCovered) {
            if (branchIsCovered) {
                row.setValue(hits, "green");
                row.setValue2(branchHits, "green");
            } else if (hasBranchCoverage) {
                row.setValue(hits, "orange");
                row.setValue2(branchHits, "orange");
                row.setSource(source, "orange");
            } else {
                row.setValue(hits, "green");
            }
        } else if (hasLineCoverage) {
            row.setValue(hits, "red");
            row.setSource(source, "red");
            if (hasBranchCoverage) {
                row.setValue2(branchHits, "red");
            } else {
                row.setValue2("&nbsp;", "red");
            }
        }
        return Arrays.asList(row);
    }
}

